//
//  IBox.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IBox_h
#define IBox_h

// IBox.h
#import <Foundation/Foundation.h>
#import <UniPRT/IRuler.h>
#import <UniPRT/IPoint.h>

/**
 * \~English
 * @protocol IBox
 * @brief A protocol defining the interface for Box classes.
 * @ingroup Interface
 *
 * \~Chinese
 * @protocol IBox
 * @brief 定义盒子类接口的协议。
 * @ingroup Interface
 *
 * \~Chinese-Traditional
 * @protocol IBox
 * @brief 定義盒子類介面的協議。
 * @ingroup Interface
 */
@protocol IBox <NSObject>

/**
 * \~English
 * @brief The ruler used for placement. If not set, the default ruler setting is used.
 *
 * \~Chinese
 * @brief 用于放置的标尺。如果未设置，则使用默认的标尺设置。
 *
 * \~Chinese-Traditional
 * @brief 用於放置的標尺。如果未設置，則使用默認的標尺設置。
 */
@property (nonatomic, strong) id<IRuler> ruler;

/**
 * \~English
 * @brief Upper left corner of the box.
 *
 * \~Chinese
 * @brief 盒子的左上角。
 *
 * \~Chinese-Traditional
 * @brief 盒子的左上角。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * \~English
 * @brief Bottom right corner of the box.
 *
 * \~Chinese
 * @brief 盒子的右下角。
 *
 * \~Chinese-Traditional
 * @brief 盒子的右下角。
 */
@property (nonatomic, strong) id<IPoint> end;

/**
 * \~English
 * @brief Thickness of the line based on the ruler units in use.
 *
 * \~Chinese
 * @brief 基于使用的标尺单位的线条厚度。
 *
 * \~Chinese-Traditional
 * @brief 基於使用的標尺單位的線條厚度。
 */
@property (nonatomic, assign) float lineThickness;

/**
 * \~English
 * @brief Rounding value of the box corner.
 *
 * \~Chinese
 * @brief 盒子角的圆角值。
 *
 * \~Chinese-Traditional
 * @brief 盒子角的圓角值。
 */
@property (nonatomic, assign) float cornerRounding;

@end

#endif /* IBox_h */
