//
//  Documentation.h
//  UniPRT
//
//  Created by Realbuber on 2024/6/6.
//

#ifndef Documentation_h
#define Documentation_h

/** @page refJsonKeyValues Settings Key/Value Items
   @htmlinclude /Users/realbuber/Documents/Project/sdk_json_Objective-C_IOS/sdk_json_Objective-C_IOS/sdk_json_Objective_C_IOS.docc/JsonKeyValueTable.html
   <!--
    % before the word prevents doxygen from generating auto link
    Include the html version of the JSON key/value pairs table
   -->
*/

/**
 * @defgroup Comm
 * @~english
 * @brief Classes and methods related to Comm.
 * @~chinese
 * @brief 与 Comm 相关的类和方法。
 * @~chinese-traditional
 * @brief 與 Comm 相關的類和方法。
 *
 * @~english
 * @details
 * [For the Objective-C  example, see here](\ref comm_objc_section).
 *
 * [For the Swift example, see here](\ref comm_swift_section).
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor comm_objc_section
 *
 * @include Objective-C/TestCommSDK/TestCommSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor comm_swift_section
 *
 * @include Swift/TestCommSDK/TestCommSDK/ContentView.swift
 * @~chinese
 * @details
 * [Objective-C 示例，请参见此处](\ref comm_objc_section)。
 *
 * [Swift 示例，请参见此处](\ref comm_swift_section)。
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor comm_objc_section
 *
 * @include Objective-C/TestCommSDK/TestCommSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor comm_swift_section
 *
 * @include Swift/TestCommSDK/TestCommSDK/ContentView.swift
 * @~chinese-traditional
 * @details
 * [Objective-C 範例，請參見此處](\ref comm_objc_section)。
 *
 * [Swift 範例，請參見此處](\ref comm_swift_section)。
 *
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor comm_objc_section
 *
 * @include Objective-C/TestCommSDK/TestCommSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor comm_swift_section
 *
 * @include Swift/TestCommSDK/TestCommSDK/ContentView.swift
 */

/**
 * @defgroup LabelMaker
 * \~english
 * @brief Classes and methods related to LabelMaker.
 * \~chinese
 * @brief 与 LabelMaker 相关的类和方法。
 * \~chinese-traditional
 * @brief 與 LabelMaker 相關的類和方法。
 *
 * \~english
 * @details
 * [For the Objective-C example, see here](\ref labelmaker_objc_section).
 *
 * [For the Swift example, see here](\ref labelmaker_swift_section).
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor labelmaker_objc_section
 *
 * @include Objective-C/TestLabelMakerSDK/TestLabelMakerSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor labelmaker_swift_section
 *
 * @include Swift/TestLabelMakerSDK/TestLabelMakerSDK/ContentView.swift
 *
 * \~chinese
 * @details
 * [Objective-C 示例，请参见此处](\ref labelmaker_objc_section)。
 *
 * [Swift 示例，请参见此处](\ref labelmaker_swift_section)。
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor labelmaker_objc_section
 *
 * @include Objective-C/TestLabelMakerSDK/TestLabelMakerSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor labelmaker_swift_section
 *
 * @include Swift/TestLabelMakerSDK/TestLabelMakerSDK/ContentView.swift
 *
 * \~chinese-traditional
 * @details
 * [Objective-C 範例，請參見此處](\ref labelmaker_objc_section)。
 *
 * [Swift 範例，請參見此處](\ref labelmaker_swift_section)。
 *
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor labelmaker_objc_section
 *
 * @include Objective-C/TestLabelMakerSDK/TestLabelMakerSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor labelmaker_swift_section
 *
 * @include Swift/TestLabelMakerSDK/TestLabelMakerSDK/ContentView.swift
 */

/**
 * @defgroup Interface
 * @ingroup LabelMaker
 * \~english
 * @brief Interface for different barcode types and formats.
 * \~chinese
 * @brief 不同条码类型和格式的接口。
 * \~chinese-traditional
 * @brief 不同條碼類型和格式的接口。
 */

/**
 * @defgroup PGL
 * @ingroup LabelMaker
 * \~english
 * @brief Interface for different barcode types and formats.
 * \~chinese
 * @brief 不同条码类型和格式的接口。
 * \~chinese-traditional
 * @brief 不同條碼類型和格式的接口。
 */

/**
 * @defgroup TSPL
 * @ingroup LabelMaker
 * \~english
 * @brief Interface for different barcode types and formats.
 * \~chinese
 * @brief 不同条码类型和格式的接口。
 * \~chinese-traditional
 * @brief 不同條碼類型和格式的接口。
 */



/**
 * @defgroup Mgmt
 * @~english
 * @brief Classes and methods related to JSONMng.
 * @~chinese
 * @brief 与 JSONMng 相关的类和方法。
 * @~chinese-traditional
 * @brief 與 JSONMng 相關的類和方法。
 *
 * @~english
 * @details
 * [For the Objective-C  example, see here](\ref mgmt_objc_section).
 *
 * [For the Swift example, see here](\ref mgmt_swift_section).
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor mgmt_objc_section
 *
 * @include Objective-C/TestMgmtCommSDK/TestMgmtCommSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor mgmt_swift_section
 *
 * @include Swift/TestMgmtCommSDK/TestMgmtCommSDK/ContentView.swift
 * @~chinese
 * @details
 * [Objective-C 示例，请参见此处](\ref mgmt_objc_section)。
 *
 * [Swift 示例，请参见此处](\ref mgmt_swift_section)。
 *
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor mgmt_objc_section
 *
 * @include Objective-C/TestMgmtCommSDK/TestMgmtCommSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor mgmt_swift_section
 *
 * @include Swift/TestMgmtCommSDK/TestMgmtCommSDK/ContentView.swift
 * @~chinese-traditional
 * @details
 * [Objective-C 範例，請參見此處](\ref mgmt_objc_section)。
 *
 * [Swift 範例，請參見此處](\ref mgmt_swift_section)。
 *
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor mgmt_objc_section
 *
 * @include Objective-C/TestMgmtCommSDK/TestMgmtCommSDK/ViewController.m
 * @subsection Swift Swift:
 * @anchor mgmt_swift_section
 *
 * @include Swift/TestMgmtCommSDK/TestMgmtCommSDK/ContentView.swift
 */

/**
 * @defgroup Monitor
 * @~english
 * @brief Classes and methods related to Monitor.
 * @~chinese
 * @brief 与 Monitor 相关的类和方法。
 * @~chinese-traditional
 * @brief 與 Monitor 相關的類和方法。
 *
 * @~english
 * @details
 * For the Objective-C  example:
 *
 * [Printer Monitor example](\ref printermonitor_objc_section)
 *
 * [Rfid Monitor example](\ref rfidmonitor_objc_section)
 *
 * [Odv Monitor example](\ref odvmonitor_objc_section)
 *
 * For the Swift example:
 *
 * [Printer Monitor example](\ref printermonitor_swift_section)
 *
 * [Rfid Monitor example](\ref rfidmonitor_swift_section)
 *
 * [Odv Monitor example](\ref odvmonitor_swift_section)
 * @section Example
 * @subsection Objective-C Objective-C:
 * @subsection PrinterMonitor Printer Monitor:
 * @anchor printermonitor_objc_section
 *
 * @include Objective-C/TestPrinterMonitor/TestPrinterMonitor/ViewController.m
 * @subsection RfidMonitor Rfid Monitor:
 * @anchor rfidmonitor_objc_section
 *
 * @include Objective-C/TestRfidMonitor/TestRfidMonitor/ViewController.m
 * @subsection OdvMonitor Odv Monitor:
 * @anchor odvmonitor_objc_section
 *
 * @include Objective-C/TestOdvMonitor/TestOdvMonitor/ViewController.m
 *
 * @subsection Swift Swift:
 * @subsection PrinterMonitorS Printer Monitor:
 * @anchor printermonitor_swift_section
 *
 * @include Swift/TestPrinterMonitor/TestPrinterMonitor/ContentView.swift
 * @subsection RfidMonitors Rfid Monitor:
 * @anchor rfidmonitor_swift_section
 *
 * @include Swift/TestRfidMonitor/TestRfidMonitor/ContentView.swift
 * @subsection OdvMonitors Odv Monitor:
 * @anchor odvmonitor_swift_section
 *
 * @include Swift/TestOdvMonitor/TestOdvMonitor/ContentView.swift
 * @~chinese
 * @details
 * 对于 Objective-C 示例：
 *
 * [打印机监视器示例](\ref printermonitor_objc_section)
 *
 * [Rfid 监视器示例](\ref rfidmonitor_objc_section)
 *
 * [Odv 监视器示例](\ref odvmonitor_objc_section)
 *
 * 对于 Swift 示例：
 *
 * [打印机监视器示例](\ref printermonitor_swift_section)
 *
 * [Rfid 监视器示例](\ref rfidmonitor_swift_section)
 *
 * [Odv 监视器示例](\ref odvmonitor_swift_section)
 * @section Example
 * @subsection Objective-C Objective-C:
 * @subsection PrinterMonitor Printer Monitor:
 * @anchor printermonitor_objc_section
 *
 * @include Objective-C/TestPrinterMonitor/TestPrinterMonitor/ViewController.m
 * @subsection RfidMonitor Rfid Monitor:
 * @anchor rfidmonitor_objc_section
 *
 * @include Objective-C/TestRfidMonitor/TestRfidMonitor/ViewController.m
 * @subsection OdvMonitor Odv Monitor:
 * @anchor odvmonitor_objc_section
 *
 * @include Objective-C/TestOdvMonitor/TestOdvMonitor/ViewController.m
 *
 * @subsection Swift Swift:
 * @subsection PrinterMonitorS Printer Monitor:
 * @anchor printermonitor_swift_section
 *
 * @include Swift/TestPrinterMonitor/TestPrinterMonitor/ContentView.swift
 * @subsection RfidMonitors Rfid Monitor:
 * @anchor rfidmonitor_swift_section
 *
 * @include Swift/TestRfidMonitor/TestRfidMonitor/ContentView.swift
 * @subsection OdvMonitors Odv Monitor:
 * @anchor odvmonitor_swift_section
 *
 * @include Swift/TestOdvMonitor/TestOdvMonitor/ContentView.swift
 * @~chinese-traditional
 * @details
 * 對於 Objective-C 範例：
 *
 * [打印機監視器範例](\ref printermonitor_objc_section)
 *
 * [Rfid 監視器範例](\ref rfidmonitor_objc_section)
 *
 * [Odv 監視器範例](\ref odvmonitor_objc_section)
 *
 * 對於 Swift 範例：
 *
 * [打印機監視器範例](\ref printermonitor_swift_section)
 *
 * [Rfid 監視器範例](\ref rfidmonitor_swift_section)
 *
 * [Odv 監視器範例](\ref odvmonitor_swift_section)
 *
 * @section Example
 * @subsection Objective-C Objective-C:
 * @subsection PrinterMonitor Printer Monitor:
 * @anchor printermonitor_objc_section
 *
 * @include Objective-C/TestPrinterMonitor/TestPrinterMonitor/ViewController.m
 * @subsection RfidMonitor Rfid Monitor:
 * @anchor rfidmonitor_objc_section
 *
 * @include Objective-C/TestRfidMonitor/TestRfidMonitor/ViewController.m
 * @subsection OdvMonitor Odv Monitor:
 * @anchor odvmonitor_objc_section
 *
 * @include Objective-C/TestOdvMonitor/TestOdvMonitor/ViewController.m
 *
 * @subsection Swift Swift:
 * @subsection PrinterMonitorS Printer Monitor:
 * @anchor printermonitor_swift_section
 *
 * @include Swift/TestPrinterMonitor/TestPrinterMonitor/ContentView.swift
 * @subsection RfidMonitors Rfid Monitor:
 * @anchor rfidmonitor_swift_section
 *
 * @include Swift/TestRfidMonitor/TestRfidMonitor/ContentView.swift
 * @subsection OdvMonitors Odv Monitor:
 * @anchor odvmonitor_swift_section
 *
 * @include Swift/TestOdvMonitor/TestOdvMonitor/ContentView.swift
 */

/**
 * @defgroup Reports
 * @~english
 * @brief Classes and methods related to Reports.
 * @~chinese
 * @brief 与 Reports 相关的类和方法。
 * @~chinese-traditional
 * @brief 與 Reports 相關的類和方法。
 */

/**
 * @defgroup Settings
 * @~english
 * @brief Support for reading and writing printer configurations.
 * @~chinese
 * @brief 支持读取和写入打印机配置。
 * @~chinese-traditional
 * @brief 支援讀取和寫入打印機配置。
 */

#endif /* Documentation_h */
