//
//  FontStyleEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef FontStyleEnum_h
#define FontStyleEnum_h

// FontStyleEnum.h
#import <Foundation/Foundation.h>

/**
 * \~English
 * @class FontStyleEnum
 * @brief This enumeration supports bitwise operation of member values.
 * @ingroup Interface
 *
 * This enumeration defines the different font styles that can be applied, supporting bitwise operations to combine multiple styles.
 *
 * | Value                           | Description                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | FontStyleNormal                 | Default/normal text.                                      |
 * | FontStyleBold                   | Bold text.                                                |
 * | FontStyleItalic                 | Italic text.                                              |
 *
 * \~Chinese
 * @class FontStyleEnum
 * @brief 此枚举支持成员值的按位操作。
 * @ingroup Interface
 *
 * 此枚举定义了可以应用的不同字体样式，支持按位操作以组合多种样式。
 *
 * | 值                             | 描述                                                      |
 * |--------------------------------|----------------------------------------------------------|
 * | FontStyleNormal                | 默认/正常文本。                                            |
 * | FontStyleBold                  | 粗体文本。                                                 |
 * | FontStyleItalic                | 斜体文本。                                                 |
 *
 * \~Chinese-Traditional
 * @class FontStyleEnum
 * @brief 此枚舉支持成員值的按位操作。
 * @ingroup Interface
 *
 * 此枚舉定義了可以應用的不同字體樣式，支持按位操作以組合多種樣式。
 *
 * | 值                             | 描述                                                      |
 * |--------------------------------|----------------------------------------------------------|
 * | FontStyleNormal                | 預設/正常文本。                                            |
 * | FontStyleBold                  | 粗體文本。                                                 |
 * | FontStyleItalic                | 斜體文本。                                                 |
 */
typedef NS_OPTIONS(NSUInteger, FontStyleEnum) {
    FontStyleNormal = 0,          ///< \~English Default/normal text. \~Chinese 默认/正常文本。 \~Chinese-Traditional 預設/正常文本。
    FontStyleBold = 1 << 0,       ///< \~English Bold text. \~Chinese 粗体文本。 \~Chinese-Traditional 粗體文本。
    FontStyleItalic = 1 << 1      ///< \~English Italic text. \~Chinese 斜体文本。 \~Chinese-Traditional 斜體文本。
};

#endif /* FontStyleEnum_h */
