//
//  IBarcodeItem.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef IBarcodeItem_h
#define IBarcodeItem_h

#import <Foundation/Foundation.h>
#import <UniPRT/IPoint.h>

/**
 * @~english
 * @protocol IBarcodeItem
 * @brief Specify barcode content and position on plane where barcode starts.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IBarcodeItem
 * @brief 指定条形码的内容和条形码开始位置的平面位置。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol IBarcodeItem
 * @brief 指定條形碼的內容和條形碼開始位置的平面位置。
 * @ingroup Interface
 */
@protocol IBarcodeItem <NSObject>

/**
 * @~english
 * @brief Position where barcode starts.
 *
 * @~chinese
 * @brief 条形码开始的位置。
 *
 * @~chinese_traditional
 * @brief 條形碼開始的位置。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * @~english
 * @brief Barcode Height. Expressed in units of Ruler.
 *
 * If limits to minimum/maximum height are exceeded, the height may be limited in order to stay within range.
 *
 * @~chinese
 * @brief 条形码高度。以标尺单位表示。
 *
 * 如果超出最小/最大高度限制，则可能会将高度限制在范围内。
 *
 * @~chinese_traditional
 * @brief 條形碼高度。以標尺單位表示。
 *
 * 如果超出最小/最大高度限制，則可能會將高度限制在範圍內。
 */
@property (nonatomic, assign) float height;

/**
 * @~english
 * @brief The barcode content.
 *
 * @~chinese
 * @brief 条形码的内容。
 *
 * @~chinese_traditional
 * @brief 條形碼的內容。
 */
@property (nonatomic, copy) NSString *data;

@end

#endif /* IBarcodeItem_h */
