//
//  Header.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef AlignEnum_h
#define AlignEnum_h

#import <Foundation/Foundation.h>

/**
 * @~english
 * @class AlignEnum
 * @brief AlignEnum type/formats.
 * @ingroup Interface
 *
 * Alignment options of object within a plane.
 *
 * | Value                    | Description                |
 * |--------------------------|----------------------------|
 * | AlignEnumDefault         | Default Align              |
 * | AlignEnumLeft            | Left Align                 |
 * | AlignEnumCenter          | Center Align               |
 * | AlignEnumRight           | Right Align                |
 *
 * @~chinese
 * @class AlignEnum
 * @brief AlignEnum 类型/格式。
 * @ingroup Interface
 *
 * 对象在平面内的对齐选项。
 *
 * | 值                        | 描述                       |
 * |--------------------------|----------------------------|
 * | AlignEnumDefault         | 默认对齐                   |
 * | AlignEnumLeft            | 左对齐                     |
 * | AlignEnumCenter          | 居中对齐                   |
 * | AlignEnumRight           | 右对齐                     |
 *
 * @~chinese_traditional
 * @class AlignEnum
 * @brief AlignEnum 類型/格式。
 * @ingroup Interface
 *
 * 對象在平面內的對齊選項。
 *
 * | 值                        | 描述                       |
 * |--------------------------|----------------------------|
 * | AlignEnumDefault         | 預設對齊                   |
 * | AlignEnumLeft            | 左對齊                     |
 * | AlignEnumCenter          | 中間對齊                   |
 * | AlignEnumRight           | 右對齊                     |
 */

typedef NS_ENUM(NSInteger, AlignEnum) {
    AlignEnumDefault,
    AlignEnumLeft,
    AlignEnumCenter,
    AlignEnumRight
};


#endif /* Header_h */
