//
//  PrintResolution.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef PrintResolution_h
#define PrintResolution_h

#import <Foundation/Foundation.h>
#import <UniPRT/IPrintResolution.h>
#import <UniPRT/Ruler.h>

/**
 * @~english
 * @class PrintResolution
 * @brief A class for PrintResolution, inheriting from IPrintResolution.
 * @ingroup Interface
 *
 * This class defines the print resolution for printers, allowing setting in dots per inch (DPI) or dots per millimeter (DPMM).
 *
 * @~chinese
 * @class PrintResolution
 * @brief 继承自 IPrintResolution 的 PrintResolution 类。
 * @ingroup Interface
 *
 * 该类定义了打印机的打印分辨率，允许以每英寸点数 (DPI) 或每毫米点数 (DPMM) 设置。
 *
 * @~chinese_traditional
 * @class PrintResolution
 * @brief 繼承自 IPrintResolution 的 PrintResolution 類。
 * @ingroup Interface
 *
 * 該類定義了打印機的打印分辨率，允許以每英寸點數 (DPI) 或每毫米點數 (DPMM) 設置。
 */
@interface PrintResolution : NSObject <IPrintResolution>

/**
 * @~english
 * @brief Define the printer resolution in dots per inch or dots per mm.
 *
 * @param dotsPerUnit The number of dots per unit (inch or mm).
 * @param unit The unit of measurement for resolution, either DPI or DPMM.
 * @return An initialized instance of PrintResolution.
 *
 * @~chinese
 * @brief 定义每英寸或每毫米的打印机分辨率。
 *
 * @param dotsPerUnit 每单位（英寸或毫米）的点数。
 * @param unit 分辨率的测量单位，可以是每英寸点数 (DPI) 或每毫米点数 (DPMM)。
 * @return 初始化的 PrintResolution 实例。
 *
 * @~chinese_traditional
 * @brief 定義每英寸或每毫米的打印機分辨率。
 *
 * @param dotsPerUnit 每單位（英寸或毫米）的點數。
 * @param unit 分辨率的測量單位，可以是每英寸點數 (DPI) 或每毫米點數 (DPMM)。
 * @return 初始化的 PrintResolution 實例。
 */
- (instancetype)initWithDotsPerUnit:(float)dotsPerUnit unit:(ScaleEnum)unit;

@end

#endif /* PrintResolution_h */
