//
//  IRfidWrite.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IRfidWrite_h
#define IRfidWrite_h

// IRfidWrite.h
#import <Foundation/Foundation.h>

#import <UniPRT/RfidMemBlockEnum.h>
#import <UniPRT/IRfidPassword.h>
#import <UniPRT/IRfidBitField.h>

/**
 * @~english
 * @protocol IRfidWrite
 * @brief Write to different areas or memory blocks of an RFID tag.
 *
 * Some tags may have security features to password protect different areas of memory.
 *
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IRfidWrite
 * @brief 写入RFID标签的不同区域或内存块。
 *
 * 一些标签可能具有密码保护不同内存区域的安全功能。
 *
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol IRfidWrite
 * @brief 寫入RFID標籤的不同區域或內存塊。
 *
 * 一些標籤可能具有密碼保護不同內存區域的安全功能。
 *
 * @ingroup Interface
 */
@protocol IRfidWrite <NSObject>

/**
 * @~english
 * @brief The memory type to access. Note that not all memory types are writable. For example, the TID (Tag Identification) is typically read-only.
 *
 * @~chinese
 * @brief 要访问的内存类型。请注意，并非所有内存类型都是可写的。例如，TID（标签标识）通常是只读的。
 *
 * @~Chinese-Traditional
 * @brief 要訪問的內存類型。請注意，並非所有內存類型都是可寫的。例如，TID（標籤標識）通常是只讀的。
 */
@property (nonatomic, assign) RfidMemBlockEnum memory;

/**
 * @~english
 * @brief The password used to access memory. Should only be set if supported by tag and use of password is desired.
 *
 * @~chinese
 * @brief 用于访问内存的密码。只有在标签支持并且需要使用密码时才应设置。
 *
 * @~Chinese-Traditional
 * @brief 用於訪問內存的密碼。只有在標籤支持並且需要使用密碼時才應設置。
 */
@property (nonatomic, strong) id<IRfidPassword> password;

/**
 * @~english
 * @brief The data to write.
 *
 * Care should be taken when writing data that is a multiple of 16-bit words due to RFID hardware possibly padding data with zeroes.
 *
 * @~chinese
 * @brief 要写入的数据。
 *
 * 由于RFID硬件可能会用零填充数据，因此在写入16位字的倍数的数据时应小心。
 *
 * @~Chinese-Traditional
 * @brief 要寫入的數據。
 *
 * 由於RFID硬件可能會用零填充數據，因此在寫入16位字的倍數的數據時應小心。
 */
@property (nonatomic, strong) id<IRfidBitField> data;

@end

#endif /* IRfidWrite_h */
