//
//  Barcode_1D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/15.
//

#ifndef Barcode_1D_h
#define Barcode_1D_h

#import <Foundation/Foundation.h>

#import <UniPRT/IPoint.h>
#import <UniPRT/ABarcode1D.h>
#import <UniPRT/BarWidths.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/IBarcodeItem.h>

/**
 * \~English
 * @class Barcode_1D
 * @brief A class representing a 1D barcode for TSPL.
 *
 * This class inherits from ABarcode1D and provides functionality for initializing and describing 1D barcodes in TSPL.
 *
 * @ingroup TSPL
 *
 * \~Chinese
 * @class Barcode_1D
 * @brief 表示用于 TSPL 的一维条码的类。
 *
 * 该类继承自 ABarcode1D，并提供了在 TSPL 中初始化和描述一维条码的功能。
 *
 * @ingroup TSPL
 *
 * \~Chinese-Traditional
 * @class Barcode_1D
 * @brief 表示用於 TSPL 的一維條碼的類。
 *
 * 該類繼承自 ABarcode1D，並提供了在 TSPL 中初始化和描述一維條碼的功能。
 *
 * @ingroup TSPL
 */
@interface Barcode_1D : ABarcode1D

/**
 * \~English
 * @brief Initializes a new instance of the Barcode_1D class.
 *
 * @return A new instance of Barcode_1D.
 *
 * \~Chinese
 * @brief 初始化 Barcode_1D 类的新实例。
 *
 * @return Barcode_1D 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化 Barcode_1D 類的新實例。
 *
 * @return Barcode_1D 的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the Barcode_1D class with the specified barcode item.
 *
 * @param barcode The barcode item to be used for initialization.
 * @return A new instance of Barcode_1D.
 *
 * \~Chinese
 * @brief 使用指定的条码项初始化 Barcode_1D 类的新实例。
 *
 * @param barcode 用于初始化的条码项。
 * @return Barcode_1D 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的條碼項初始化 Barcode_1D 類的新實例。
 *
 * @param barcode 用於初始化的條碼項。
 * @return Barcode_1D 的新實例。
 */
- (instancetype)initWithBarcodeItem:(id<IBarcodeItem>)barcode;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the Barcode_1D instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing in TSPL.
 *
 * @return A string description of the Barcode_1D instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 Barcode_1D 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括在 TSPL 中打印所需的所有命令和数据。
 *
 * @return Barcode_1D 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 Barcode_1D 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括在 TSPL 中打印所需的所有命令和數據。
 *
 * @return Barcode_1D 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* Barcode_1D_h */
