//
//  IAlignment.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef IAlignment_h
#define IAlignment_h

#import <Foundation/Foundation.h>
#import <UniPRT/AlignEnum.h>
/**
 * @~english
 * @protocol IAlignment
 * @brief A protocol defining the interface for Alignment classes.
 * @ingroup Interface
 *
 * This protocol provides the methods and properties required to define the alignment of objects within a plane.
 *
 * @~chinese
 * @protocol IAlignment
 * @brief 定义对齐类接口的协议。
 * @ingroup Interface
 *
 * 此协议提供定义平面内对象对齐所需的方法和属性。
 *
 * @~Chinese-Traditional
 * @protocol IAlignment
 * @brief 定義對齊類介面的協議。
 * @ingroup Interface
 *
 * 此協議提供定義平面內對象對齊所需的方法和屬性。
 */
@protocol IAlignment <NSObject>

@property (nonatomic, assign) AlignEnum alignment;

@end

#endif /* IAlignment_h */
