//
//  _PglBox.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef _PglBox_h
#define _PglBox_h

#import <Foundation/Foundation.h>

#import <UniPRT/IBox.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/Defaults.h>
#import <UniPRT/Point.h>
#import <UniPRT/PglBox.h>

/**
 * \~English
 * @class _PglBox
 * @brief A class representing a box shape.
 *
 * This class implements the IBox protocol and provides functionality for initializing and describing a box.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class _PglBox
 * @brief 表示一个盒子形状的类。
 *
 * 该类实现了 IBox 协议，并提供了初始化和描述盒子的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class _PglBox
 * @brief 表示一個盒子形狀的類。
 *
 * 該類實現了 IBox 協議，並提供了初始化和描述盒子的功能。
 *
 * @ingroup PGL
 */
@interface _PglBox : NSObject <IBox>

/**
 * \~English
 * @brief The ruler used to measure the box.
 *
 * \~Chinese
 * @brief 用于测量盒子的尺子。
 *
 * \~Chinese-Traditional
 * @brief 用於測量盒子的尺子。
 */
@property (nonatomic, strong) id<IRuler> ruler;

/**
 * \~English
 * @brief The starting point of the box.
 *
 * \~Chinese
 * @brief 盒子的起始点。
 *
 * \~Chinese-Traditional
 * @brief 盒子的起始點。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * \~English
 * @brief The ending point of the box.
 *
 * \~Chinese
 * @brief 盒子的结束点。
 *
 * \~Chinese-Traditional
 * @brief 盒子的結束點。
 */
@property (nonatomic, strong) id<IPoint> end;

/**
 * \~English
 * @brief The thickness of the box's lines.
 *
 * \~Chinese
 * @brief 盒子线条的厚度。
 *
 * \~Chinese-Traditional
 * @brief 盒子線條的厚度。
 */
@property (nonatomic) float lineThickness;

/**
 * \~English
 * @brief The corner rounding radius of the box.
 *
 * \~Chinese
 * @brief 盒子角落的圆角半径。
 *
 * \~Chinese-Traditional
 * @brief 盒子角落的圓角半徑。
 */
@property (nonatomic) float cornerRounding;

/**
 * \~English
 * @brief Initializes a new instance of the _PglBox class with specified start and end points and line thickness.
 *
 * @param start The starting point of the box.
 * @param end The ending point of the box.
 * @param lineThickness The thickness of the box's lines.
 * @return A new instance of _PglBox.
 *
 * \~Chinese
 * @brief 使用指定的起始点、结束点和线条厚度初始化 _PglBox 类的新实例。
 *
 * @param start 盒子的起始点。
 * @param end 盒子的结束点。
 * @param lineThickness 盒子线条的厚度。
 * @return _PglBox 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點、結束點和線條厚度初始化 _PglBox 類的新實例。
 *
 * @param start 盒子的起始點。
 * @param end 盒子的結束點。
 * @param lineThickness 盒子線條的厚度。
 * @return _PglBox 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start end:(id<IPoint>)end lineThickness:(float)lineThickness;

/**
 * \~English
 * @brief Initializes a new instance of the _PglBox class with specified start and end coordinates and line thickness.
 *
 * @param xStart The x-coordinate of the starting point.
 * @param yStart The y-coordinate of the starting point.
 * @param xEnd The x-coordinate of the ending point.
 * @param yEnd The y-coordinate of the ending point.
 * @param lineThickness The thickness of the box's lines.
 * @return A new instance of _PglBox.
 *
 * \~Chinese
 * @brief 使用指定的起始坐标、结束坐标和线条厚度初始化 _PglBox 类的新实例。
 *
 * @param xStart 起始点的 x 坐标。
 * @param yStart 起始点的 y 坐标。
 * @param xEnd 结束点的 x 坐标。
 * @param yEnd 结束点的 y 坐标。
 * @param lineThickness 盒子线条的厚度。
 * @return _PglBox 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始坐標、結束坐標和線條厚度初始化 _PglBox 類的新實例。
 *
 * @param xStart 起始點的 x 坐標。
 * @param yStart 起始點的 y 坐標。
 * @param xEnd 結束點的 x 坐標。
 * @param yEnd 結束點的 y 坐標。
 * @param lineThickness 盒子線條的厚度。
 * @return _PglBox 的新實例。
 */
- (instancetype)initWithXStart:(float)xStart yStart:(float)yStart xEnd:(float)xEnd yEnd:(float)yEnd lineThickness:(float)lineThickness;

/**
 * \~English
 * @brief Returns a string that describes the contents of the receiver.
 *
 * @return A string description of the _PglBox instance.
 *
 * \~Chinese
 * @brief 返回描述接收者内容的字符串。
 *
 * @return _PglBox 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回描述接收者內容的字符串。
 *
 * @return _PglBox 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* _PglBox_h */
