//
//  FontSize.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef FontSize_h
#define FontSize_h

// FontSize.h
#import <Foundation/Foundation.h>
#import <UniPRT/APair.h>
#import <UniPRT/IFontSize.h>

/**
 * \~English
 * @class FontSize
 * @brief Font size in the X and Y direction allows for stretching/resizing when non-default font size is desired.
 * @ingroup Interface
 *
 * The FontSize class represents the size of a font in the X and Y directions, allowing for customization and resizing. It inherits from APair and conforms to the IFontSize protocol.
 *
 * \~Chinese
 * @class FontSize
 * @brief 字体在 X 和 Y 方向的大小，允许在需要非默认字体大小时进行拉伸/调整大小。
 * @ingroup Interface
 *
 * FontSize 类表示字体在 X 和 Y 方向上的大小，允许进行自定义和调整大小。它继承自 APair 并符合 IFontSize 协议。
 *
 * \~Chinese-Traditional
 * @class FontSize
 * @brief 字體在 X 和 Y 方向的大小，允許在需要非默認字體大小時進行拉伸/調整大小。
 * @ingroup Interface
 *
 * FontSize 類表示字體在 X 和 Y 方向上的大小，允許進行自定義和調整大小。它繼承自 APair 並符合 IFontSize 協議。
 */
@interface FontSize : APair <IFontSize>
- (instancetype)initWithX:(float)x y:(float)y;
@end


#endif /* FontSize_h */
