//
//  SettingsReadWrite.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/14.
//

#ifndef SettingsReadWrite_h
#define SettingsReadWrite_h


#endif /* SettingsReadWrite_h */
#import <Foundation/Foundation.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonComm.h>
#import <AutoIdSDK/Setting.h>
#import <AutoIdSDK/JsonCommController.h>
#import <AutoIdSDK/Debug.h>
#import <AutoIdSDK/JsonStringBuilder.h>
#import <AutoIdSDK/JsonStringTokenizer.h>




extern NSString *const CMD_ITEM;
extern NSString *const CMD_PROP;

@interface SettingsReadWrite : NSObject

- (instancetype)initWithTcpComm:(TcpComm *)connection;
- (instancetype)initWithJsonComm:(JsonComm *)mgmtComm;
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;

- (NSDictionary<NSString *, NSString *> *)getAllValues;
- (NSString *)getValueForKey:(NSString *)key;
- (NSDictionary<NSString *, NSString *> *)getValuesForKeys:(NSArray<NSString *> *)keys;
- (BOOL)setValue:(NSString *)value forKey:(NSString *)key;
- (BOOL)setValues:(NSDictionary<NSString *, NSString *> *)keysToSet;
- (Setting *)getPropertiesForKey:(NSString *)key;
- (NSDictionary<NSString *, Setting *> *)getPropertiesForKeys:(NSArray<NSString *> *)keys;
- (NSDictionary<NSString *, Setting *> *)getAllProperties;


@end
