//
//  TcpComm.h
//  sdk_json_Objective-C_IOS
//
//  Created by Realbuber on 2024/4/23.
//

#ifndef TcpComm_h
#define TcpComm_h


#endif /* TcpComm_h */
#import <Foundation/Foundation.h>
#import <AutoIdSDK/AComm.h>

extern const int DEFAULT_DATA_PORT;
extern const int DEFAULT_STATUS_PORT;
extern const int DEFAULT_MGMT_PORT;

@interface TcpComm : AComm <NSStreamDelegate>
@property (nonatomic, readonly) NSInputStream *inputStream;
@property (nonatomic, readonly) NSOutputStream *outputStream;
@property (nonatomic, readwrite) BOOL connected;

- (instancetype)initWithIPAddress:(NSString *)ipAddress port:(NSUInteger)port;
- (void)open;
- (void)close;
- (void)write:(NSData *)text;
- (NSData *)read;
- (NSString *) descriptorUseIp: (NSString *)ip descriptorUsePort:(NSString *) port;
- (NSData *)writeAndWaitForResponse:(NSData *)text
               responseStartTimeOut:(NSTimeInterval)responseStartTimeOut
                 responseEndTimeOut:(NSTimeInterval)responseEndTimeOut
                    completionToken:(NSString *)completionToken;

- (NSData *)writeAndWaitForResponseJson:(NSData *)text
               responseStartTimeOut:(NSTimeInterval)responseStartTimeOut
                 responseEndTimeOut:(NSTimeInterval)responseEndTimeOut
                    completionToken:(NSString *)completionToken;

typedef NS_ENUM(NSInteger, DescriptorPortType) {
    DescriptorPortTypeData,
    DescriptorPortTypeMGMT,
    DescriptorPortTypeStatus,
};

-(void) connectionSettingsWithIP:(NSString *)ip port:(NSUInteger )port;
- (NSString *)validateDescriptor:(NSString *)descriptorHint withPortType:(DescriptorPortType)portTypeHint;
- (void)sendPrintFile:(NSString *)ipAddress fileName:(NSString *)fileName;
- (void)sendPrintString:(NSString *)ipAddress data:(NSData *)data;
- (void)writePrinterFile:(NSString *)fileName;
@end
