//
//  ADataMatrix.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ADataMatrix_h
#define ADataMatrix_h

//#import <sdk_json_Objective_C/ABarcode2D.h>
//#import <sdk_json_Objective_C/ISquareCell.h>
//
//@interface ADataMatrix : ABarcode2D <ISquareCell>
//
//@property (nonatomic, assign) BOOL rectangle;
//@property (nonatomic, strong) id<ICellSquare> cellSize; // From ISquareCell
//@property (nonatomic) NSInteger rows;  // Part of the Tuple in C#
//@property (nonatomic) NSInteger cols;  // Part of the Tuple in C#
//
//// Methods
//- (NSString *)ctrlCharForDecimalValue:(NSInteger)decimalCharValue;
//- (NSString *)fnc1;
//
//@end
#import <Foundation/Foundation.h>
#import <AutoIdSDK/ISquareCell.h>
#import <AutoIdSDK/ABarcode2D.h>
#import <AutoIdSDK/IPoint.h>
@interface ADataMatrix : ABarcode2D <ISquareCell>

@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, assign) char ctrlCharDelimiter;
@property (nonatomic, assign) BOOL rectangle;
@property (nonatomic, strong) id<ICellSquare> cellSize;
@property (nonatomic, strong) NSValue *rowsCols; // Use NSValue to hold a tuple of int values
@property (nonatomic, readonly) NSString *fnc1;

- (instancetype)init;
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;
- (NSString *)ctrlChar:(int)decimalCharValue;

@end

#endif /* ADataMatrix_h */
