//
//  RfidWrite.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/13.
//

#ifndef RfidWrite_h
#define RfidWrite_h

#import <UniPRT/RfidWriteProperties.h>
#import <UniPRT/RfidWriteBitField.h>
#if !defined(HIDE_PGL_INTERFACES)



@interface RfidWrite : NSObject


@property (nonatomic, strong) RfidWriteProperties *props;
@property (nonatomic, strong) NSMutableArray<RfidWriteBitField *> *bitFields;



- (instancetype)initWithMemBank:(TSPLRfidMemBlock)memBank dataFormat:(TSPLRfidFormat)dataFormat bitCount:(int)bitCount data:(NSString *)data;
- (instancetype)initWithWriteProperties:(RfidWriteProperties *)writeProps firstBitField:(RfidWriteBitField *)firstBitField;
- (void)addBitField:(RfidWriteBitField *)bitFieldToAdd;
- (NSString *)description;

@end
#endif
#endif /* RfidWrite_h */
