#include "OdvReport.h"

std::string OdvReport::Data() const {
/*
    auto asciiIt = rawReport.find("Ascii");
    if (asciiIt != rawReport.end()) {
        return asciiIt->second;
    }
    else {
        auto base64It = rawReport.find("Base64");
        if (base64It != rawReport.end()) {
            return DecodeBase64(base64It->second);
        }
        else {
            return "Error: Unknown Data";
        }
    }
*/
    for (const auto& entry : rawReport)
    {
        std::string first = entry.first;
        std::string second = entry.second;

        nlohmann::json json_data = nlohmann::json::parse(second);
        if (json_data.find("Ascii") != json_data.end()) {
            // Try to get the nested JSON object
            nlohmann::json data = json_data.at("Ascii");


            // Check if 'content' is a valid JSON object
            std::string result;
            result.clear();

            for (auto& item : data.items()) {
                result += item.value().dump();
            }



            return result;
        }
        else
        if (json_data.find("Base64") != json_data.end()) {
            // Try to get the nested JSON object
            nlohmann::json data = json_data.at("Base64");


            // Check if 'content' is a valid JSON object
            std::string result;
            result.clear();

            for (auto& item : data.items()) {
                result += item.value().dump();
            }


            result.erase(std::remove(result.begin(), result.end(), '\"'), result.end());
            return DecodeBase64(result);
        }
        else {

            return "Error: Unknown Data";
        }




    }

    return "Error: Unknown Data";


}



float OdvReport::OverallGradeAsFloat() const {

    //auto it = rawReport.find("Grade");
    //if (it != rawReport.end()) {
    //    std::size_t pos = it->second.find('(');
    //    if (pos != std::string::npos) {
    //        std::string floatGradeAsString = it->second.substr(pos + 1);
    //        return std::stof(floatGradeAsString);
    //    }
    //}
    //return 0.0f;


    for (const auto& entry : rawReport)
    {
        std::string first = entry.first;
        std::string second = entry.second;

        nlohmann::json json_data = nlohmann::json::parse(second);
        if (json_data.find("Grade") != json_data.end()) {
            // Try to get the nested JSON object
            nlohmann::json data = json_data.at("Grade");


            // Check if 'content' is a valid JSON object
            std::string result;
            result.clear();

            for (auto& item : data.items()) {
                result += item.value().dump();
            }

            std::size_t pos = result.find('(');
            if (pos != std::string::npos) {
                std::string floatGradeAsString = result.substr(pos + 1);
                return std::stof(floatGradeAsString);

            }
        }
        else {

            return 0.0f;
        }




    }

    return 0.0f;


}

/*
std::vector<uint8_t> OdvReport::base64Decode(const std::string& base64Str, bool urlSafe) const
{
    const std::string base64Chars = urlSafe ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_" : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    std::vector<uint8_t> decodedData;

    // Build decoding table
    std::vector<int> decodingTable(256, -1);
    for (int i = 0; i < base64Chars.size(); ++i) {
        decodingTable[static_cast<unsigned char>(base64Chars[i])] = i;
    }

    size_t padding = 0;
    if (!base64Str.empty() && base64Str.back() == '=') {
        padding++;
        if (!base64Str.empty() && base64Str[base64Str.size() - 2] == '=') {
            padding++;
        }
    }

    for (size_t i = 0; i < base64Str.size(); i += 4) {
        uint32_t block = 0;

        for (size_t j = 0; j < 4; ++j) {
            block <<= 6;

            if (i + j < base64Str.size()) {
                size_t index = decodingTable[static_cast<unsigned char>(base64Str[i + j])];
                if (index != static_cast<size_t>(-1)) {
                    block |= static_cast<uint32_t>(index);
                }
            }
        }

        for (size_t j = 0; j < 3 - padding; ++j) {
            uint8_t byte = (block >> ((2 - j) * 8)) & 0xFF;
            decodedData.push_back(byte);
        }
    }

    return decodedData;

}
*/

static const std::string base64_chars =
"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
"abcdefghijklmnopqrstuvwxyz"
"0123456789+/";


static inline bool is_base64(unsigned char c) {
    return (isalnum(c) || (c == '+') || (c == '/'));
}

std::string OdvReport::base64Decode(const std::string& encoded_string) const {
    size_t in_len = encoded_string.size();
    int i = 0;
    int j = 0;
    int in_ = 0;
    unsigned char char_array_4[4], char_array_3[3];
    std::string ret;

    while (in_len-- && (encoded_string[in_] != '=') && is_base64(encoded_string[in_])) {
        char_array_4[i++] = encoded_string[in_]; in_++;
        if (i == 4) {
            for (i = 0; i < 4; i++)
                char_array_4[i] = base64_chars.find(char_array_4[i]) & 0xff;

            char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
            char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
            char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

            for (i = 0; (i < 3); i++)
                ret += char_array_3[i];
            i = 0;
        }
    }

    if (i) {
        for (j = 0; j < i; j++)
            char_array_4[j] = base64_chars.find(char_array_4[j]) & 0xff;

        char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
        char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);

        for (j = 0; (j < i - 1); j++) ret += char_array_3[j];
    }

    return ret;
}



std::string OdvReport::DecodeBase64(const std::string& base64) const
{
    //std::vector<uint8_t> decodedData = base64Decode(base64);
    // N vector ഫ string
    //std::string result(decodedData.begin(), decodedData.end());
     //N vector ഫ stringAýTO]t null r
    //std::string result(reinterpret_cast<char*>(decodedData.data()), decodedData.size());

    //return result;
    return base64Decode(base64);


}