#include "CommSDK.h"
#include "JsonSDK.h"
#include <cstdio>
#include <iostream>
#include <string>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>



using byte = unsigned char;


void ShowPrinterInfo(stPrinterInfo* pPrtInfo, INFO_TYP InfoTyp)
{
	GetPrinterInfo(pPrtInfo, InfoTyp);

	std::cout << std::endl;
	std::cout << "Printer Model: " << pPrtInfo->Model << std::endl;
	std::cout << "Printer SN: " << pPrtInfo->SerialNumber << std::endl;
	std::cout << "Printer FW PN: " << pPrtInfo->FirmwarePartNumber << std::endl;
	std::cout << "Printer FW Ver: " << pPrtInfo->FirmwareVersion << std::endl;
	std::cout << "Printhead Resolution (Dots/Inch): " << pPrtInfo->PrintheadResolution << std::endl;
	std::cout << std::endl;
	std::cout << "Has ODV: " << (pPrtInfo->HasOdvOption ? "yes" : "no") << std::endl;


}


void OdvReportCallback(const OdvReport& report)
{
	if (report.Failed())
	{
		std::cout << "\nBarcode Failed." << std::endl;
	}
	else
	{
		std::cout << "\nBarcode Passed." << std::endl;
		std::cout << "Grade: " << report.OverallGrade() << std::endl;

		if (report.OverallGradeAsFloat() > 3.5)
		{
			std::cout << "Print Quality passed.  \n  Overall Grade= " << std::to_string(report.OverallGradeAsFloat()) << std::endl;
		}
		else
		{
			std::cout << "Print Quality Failed.  \n  Overall Grade= " << std::to_string(report.OverallGradeAsFloat()) << std::endl;
		}

		std::cout << "Barcode Symbology: " << report.Symbology() << std::endl;
		std::cout << "Barcode Data: " << report.Data() << std::endl;
	}
}

int main()
{
	
	stPrinterInfo PrtInfo;
	std::string ptrIpOdv = "10.0.10.190";

	OdvMonitorConnection((char*)ptrIpOdv.c_str());
	PrinterMonitorConnection((char*)ptrIpOdv.c_str(), INFO_TYP::ODV_TYP);

	std::cout << "\n=======Odv Printer Info: ";
	ShowPrinterInfo(&PrtInfo, INFO_TYP::ODV_TYP);


	if (PrtInfo.HasOdvOption == false)
	{
		std::cout << "WARNING: Missing ODV option on printer at: " << ptrIpOdv << std::endl;
		return 1;
	}


	// ============================
	// -------------  ODV Printer: setup for RFID report monitoring
	// ============================
	SetOdvReportListening(true);
	SetOdvReportCallback(OdvReportCallback);


	SendPrintFile((char*)(ptrIpOdv.c_str()), (char*)"DM_PRINTRONIX_1.pgl");
	std::cout << "Sending datamatrix barcode print job..." << std::endl;


	int userInput;

	// 循環等待用戶輸入，直到用戶輸入0為止
	do {

		std::cout << std::endl;
		std::cout << std::endl;
		std::cout << "Press 0 to exit";
		std::cout << std::endl;
		std::cin >> userInput;
	} while (userInput != 0);

	// 使用者輸入0後程式結束
	std::cout << std::endl;
	std::cout << "Program exit" << std::endl;
	std::cout << std::endl;

	Close();
	OdvMonitorDispose();
	PrinterMonitorDispose(INFO_TYP::ODV_TYP);


	
	return 0;

}



