//
//  AMaxicodeMsg.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef AMaxicodeMsg_h
#define AMaxicodeMsg_h

#import <Foundation/Foundation.h>
#import <UniPRT/IMaxicodeMsg.h>

/**
 * @~english
 * @class AMaxicodeMsg
 * @brief This class is for modes with free-form messages. Does not apply to Mode 2 or 3.
 * @ingroup Interface
 *
 * @~chinese
 * @class AMaxicodeMsg
 * @brief 该类适用于自由格式消息的模式。不适用于模式2或模式3。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @class AMaxicodeMsg
 * @brief 該類適用於自由格式消息的模式。不適用於模式2或模式3。
 * @ingroup Interface
 */

@interface AMaxicodeMsg : NSObject <IMaxicodeMsg>

@property (nonatomic, assign) MaxicodeModeEnum mode; // Using specific enum type instead of general Enum
@property (nonatomic, copy) NSString *primaryMsg;
@property (nonatomic, copy) NSString *remainingMsg;
@property (nonatomic, readonly, copy) NSString *data;

- (instancetype)init;
- (instancetype)initWithMode:(MaxicodeModeEnum)mode primaryMsg:(NSString *)primaryMsg remainingMsg:(NSString *)remainingMsg NS_DESIGNATED_INITIALIZER;

@end

#endif /* AMaxicodeMsg_h */
