//
//  Barcode1D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/13.
//

#ifndef Barcode1D_h
#define Barcode1D_h
#import <UniPRT/TSPL.h>
#import <UniPRT/Barcode1DProperties.h>
#if !defined(HIDE_PGL_INTERFACES)

/** @cond */

@interface Barcode1D : NSObject
@property (nonatomic, assign) int SR;
@property (nonatomic, assign) int SC;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, assign) TSPLBarcodeType1D bcdType;
@property (nonatomic, strong) NSString *magnification;
@property (nonatomic, assign) float height;
@property (nonatomic, assign) TSPLRotation rotation;
@property (nonatomic, assign) BOOL pdf;
@property (nonatomic, assign) BOOL pdfLocTop;

- (instancetype)initWithBcdType:(TSPLBarcodeType1D)bcdType SR:(int)sr SC:(int)sc Data:(NSString *)data;
- (instancetype)initWithBcdProps:(Barcode1DProperties *)bcdProps SR:(int)sr SC:(int)sc Data:(NSString *)data;

- (NSString *)description;

@end

/** @endcond */

#endif /* Barcode1D_h */
#endif
