//
//  QRCodeModelEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef QRCodeModelEnum_h
#define QRCodeModelEnum_h

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class QRCodeModelEnum
 * @brief QR barcodes have increased in capacity and readability. Model 1 is the original, and other models improve readability and data capacity.
 *
 * The QRCodeModelEnum class defines the different models of QR codes available for use, each with specific characteristics and capabilities.
 *
 * @ingroup Interface
 *
 * \~Chinese
 * @class QRCodeModelEnum
 * @brief QR条形码的容量和可读性得到了提高。模型1是原始的，其他模型提高了可读性和数据容量。
 *
 * QRCodeModelEnum 类定义了可用的不同型号的QR码，每种型号具有特定的特性和能力。
 *
 * @ingroup Interface
 *
 * \~Chinese-Traditional
 * @class QRCodeModelEnum
 * @brief QR條形碼的容量和可讀性得到了提高。模型1是原始的，其他模型提高了可讀性和數據容量。
 *
 * QRCodeModelEnum 類定義了可用的不同型號的QR碼，每種型號具有特定的特性和能力。
 *
 * @ingroup Interface
 */
typedef NS_ENUM(NSUInteger, QRCodeModelEnum) {
    QRCodeModel1,  ///< \~English Model 1 - Original. \~Chinese 模型1 - 原始版。 \~Chinese-Traditional 模型1 - 原始版。
    QRCodeModel2   ///< \~English Model 2 - Improved readability and capacity. \~Chinese 模型2 - 提高了可读性和容量。 \~Chinese-Traditional 模型2 - 提高了可讀性和容量。
};

#endif /* QRCodeModelEnum_h */
