//
//  IMaxicodeMsgStructuredOpenSystemStandard.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IMaxicodeMsgStructuredOpenSystemStandard_h
#define IMaxicodeMsgStructuredOpenSystemStandard_h

#import <Foundation/Foundation.h>
#import <UniPRT/IMaxicodeData.h>

/**
 * @~english
 * @protocol IMaxicodeMsgStructuredOpenSystemStandard
 * @brief Maxicode barcode data. Maxicode Open System Standard carrier message. Only applies to Mode 2 and 3.
 * The Open System Standard carrier message format is typically encoded into a barcode with a `"[)><Rs>01<Gs>"` prefix as follows:
 *
 * @code
 * "[)>"<Rs>"01"<Gs><yy><PostalCode><Gs><CountryCode><Gs><ServiceClass><Gs><RemainingMsg><Rs><EOT>
 * @endcode
 *
 * Where:
 *
 * - yy: 2 char year (numeric)
 * - Rs: Record Separator (0x1E)
 * - Gs: Group Separator (0x1D)
 * - EOT: End Of Transmit (0x04)
 *
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IMaxicodeMsgStructuredOpenSystemStandard
 * @brief Maxicode 条码数据。Maxicode 开放系统标准承载消息。仅适用于模式 2 和 3。
 * 开放系统标准承载消息格式通常以 `"[)><Rs>01<Gs>"` 前缀编码为条形码，如下所示：
 *
 * @code
 * "[)>"<Rs>"01"<Gs><yy><PostalCode><Gs><CountryCode><Gs><ServiceClass><Gs><RemainingMsg><Rs><EOT>
 * @endcode
 *
 * 其中：
 *
 * - yy: 2 位数字的年份
 * - Rs: 记录分隔符 (0x1E)
 * - Gs: 组分隔符 (0x1D)
 * - EOT: 传输结束 (0x04)
 *
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol IMaxicodeMsgStructuredOpenSystemStandard
 * @brief Maxicode 條碼數據。Maxicode 開放系統標準承載消息。僅適用於模式 2 和 3。
 * 開放系統標準承載消息格式通常以 `"[)><Rs>01<Gs>"` 前綴編碼為條碼，如下所示：
 *
 * @code
 * "[)>"<Rs>"01"<Gs><yy><PostalCode><Gs><CountryCode><Gs><ServiceClass><Gs><RemainingMsg><Rs><EOT>
 * @endcode
 *
 * 其中：
 *
 * - yy: 2 位數字的年份
 * - Rs: 記錄分隔符 (0x1E)
 * - Gs: 組分隔符 (0x1D)
 * - EOT: 傳輸結束 (0x04)
 *
 * @ingroup Interface
 */

@protocol IMaxicodeMsgStructuredOpenSystemStandard <IMaxicodeData>

@property (nonatomic, copy) NSString *postalCode;
@property (nonatomic, copy) NSString *countryCode;
@property (nonatomic, copy) NSString *serviceClass;
@property (nonatomic, copy) NSString *year;
@property (nonatomic, copy) NSString *remainingMsg;

@end

#endif /* IMaxicodeMsgStructuredOpenSystemStandard_h */

