//
//  Defaults.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef Defaults_h
#define Defaults_h

#import <Foundation/Foundation.h>
#import <AutoIdSDK/IRuler.h>
#import <AutoIdSDK/CONST.h>
#import <AutoIdSDK/IPrintResolution.h>
#import <AutoIdSDK/IBarcode2D.h>
#import <AutoIdSDK/AlignEnum.h>
#import <AutoIdSDK/RotateEnum.h>
#import <AutoIdSDK/ICellSquare.h>
#import <AutoIdSDK/ICellRect.h>

@interface Defaults : NSObject

@property (class, nonatomic, strong) id<IPrintResolution> printerResolution;
@property (class, nonatomic, strong) id<IRuler> ruler;
@property (class, nonatomic, assign) AlignEnum alignment;
@property (class, nonatomic, assign) RotateEnum rotation;
@property (class, nonatomic, strong) id<ICellSquare> cellSize;
@property (class, nonatomic, strong) id<ICellRect> cellSizeRect;

+ (id<IPrintResolution>)printerResolution;
+ (void)SetPrinterResolution:(id<IPrintResolution>)printerResolution;

+ (id<IRuler>)ruler;
+ (void)SetRuler:(id<IRuler>)ruler;

+ (AlignEnum)alignment;
+ (void)SetAlignment:(AlignEnum)alignment;

+ (RotateEnum)rotation;
+ (void)SetRotation:(RotateEnum)rotation;

+ (id<ICellSquare>)cellSize;
+ (void)SetCellSize:(id<ICellSquare>)cellSize;

+ (id<ICellRect>)cellSizeRect;
+ (void)SetCellSizeRect:(id<ICellRect>)cellSizeRect;

@end

#endif /* Defaults_h */




