//
//  AppDelegate.h
//  TestCommSDK
//
//  Created by Realbuber on 2024/4/22.
//

#import <Cocoa/Cocoa.h>

@class BtComm;
@class UsbComm;
@class UsbConnection;
@class TcpComm;

@class AComm;

@class PrinterInfo;
@class PrinterMonitor;
@class JsonComm;

@interface AppDelegate : NSObject <NSApplicationDelegate>

@property (strong, nonatomic) NSWindow *window;
@property (strong) NSPopUpButton *devicePopUpButton;

@property (strong) BtComm *btComm;
@property (strong) UsbComm *usbComm;
@property (strong) TcpComm *tcpComm;
@property (strong) UsbConnection *uComm;
@property (strong) NSTextField *label;
@property (strong) NSTextView *textView;
@property (strong) NSTextField *connectionStatus;


// 添加属性以引用复选框
@property (strong) NSButton *usbCheckBox;
@property (strong) NSButton *tcpCheckBox;
@property (strong) NSButton *btCheckBox;

// 添加属性以引用按钮，以便我们可以在运行时更改它们的行为
@property (strong) NSButton *openButton;
@property (strong) NSButton *readButton;
@property (strong) NSButton *writeButton;
@property (strong) NSButton *closeButton;
@property (strong) NSButton *writeAndWaitButton;


@property (strong) NSTextField *tcpIpInputField;
@property (strong) NSTextField *btAddressInputField;
// 蓝牙相关方法
- (void)openT:(id)sender;
- (void)writeT:(id)sender;
- (IBAction)readT:(id)sender;

// USB 相关方法
-(void)deviceSelectionChanged:(NSPopUpButton *)sender;
-(void)openUsb:(id)sender;
- (void)writeUsb:(id)sender;
- (IBAction)readUsb:(id)sender;
- (IBAction)writeAndWaitForResponseUsb:(id)sender;

// TCP 相关方法
-(void)openTcp:(id)sender;
- (void)writeTcp:(id)sender;
- (IBAction)readTcp:(id)sender;
- (IBAction)writeAndWaitForResponseTcp:(id)sender;

@end
