//
//  AMaxicodeMsgStructured.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef AMaxicodeMsgStructured_h
#define AMaxicodeMsgStructured_h

#import <Foundation/Foundation.h>
#import <UniPRT/IMaxicodeMsgStructured.h>

/**
 * @~english
 * @class AMaxicodeMsgStructured
 * @brief This class is only applicable for Mode 2 or 3.
 * @ingroup Interface
 *
 * Provides functionality specific to Maxicode messages that use Mode 2 or 3. This class handles the structured message format
 * used in Maxicode for these modes, which are typically utilized for shipping and postal purposes.
 *
 * @~chinese
 * @class AMaxicodeMsgStructured
 * @brief 该类仅适用于模式2或模式3。
 * @ingroup Interface
 *
 * 提供专用于使用模式2或模式3的Maxicode消息的功能。该类处理这些模式中Maxicode使用的结构化消息格式，通常用于运输和邮政目的。
 *
 * @~Chinese-Traditional
 * @class AMaxicodeMsgStructured
 * @brief 該類僅適用於模式2或模式3。
 * @ingroup Interface
 *
 * 提供專用於使用模式2或模式3的Maxicode消息的功能。該類處理這些模式中Maxicode使用的結構化消息格式，通常用於運輸和郵政目的。
 */
@interface AMaxicodeMsgStructured : NSObject <IMaxicodeMsgStructured>

@property (nonatomic, copy) NSString *postalCode;
@property (nonatomic, copy) NSString *countryCode;
@property (nonatomic, copy) NSString *serviceClass;
@property (nonatomic, copy) NSString *remainingMsg;
@property (nonatomic, assign) MaxicodeModeEnum mode;  // Enum, assuming MaxicodeModeEnum is already defined

- (instancetype)init;
- (instancetype)initWithMode:(MaxicodeModeEnum)mode postalCode:(NSString *)postalCode countryCode:(NSString *)countryCode serviceClass:(NSString *)serviceClass remainingMsg:(NSString *)remainingMsg NS_DESIGNATED_INITIALIZER;
- (NSString *)data;

@end

#endif /* AMaxicodeMsgStructured_h */
