//
//  Documentation.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/23.
//

#ifndef Documentation_h
#define Documentation_h

/** @page refJsonKeyValues Settings Key/Value Items
   @htmlinclude /Users/realbuber/Documents/Project/sdk_json_Objective-C/AutoIdSDK/sdk_json_Objective_C.docc/JsonKeyValueTable.html
   <!--
    % before the word prevents doxygen from generating auto link
    Include the html version of the JSON key/value pairs table
   -->
*/

/**
 * @defgroup Comm
 * @brief Classes and methods related to Comm.
 * @details
 * [For the Objective-C  example, see here](\ref comm_objc_section).
 *
 * [For the Swift example, see here](\ref comm_swift_section).
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor comm_objc_section
 *
 * @include Objective-C/TestCommSDK/TestCommSDK/AppDelegate.m
 * @subsection Swift Swift:
 * @anchor comm_swift_section
 *
 * @include Swift/TestCommSDK/TestCommSDK/ContentView.swift
 */

/**
 * @defgroup LabelMaker
 * @brief Classes and methods related to LabelMaker.
 * @details
 * [For the Objective-C  example, see here](\ref labelmaker_objc_section).
 *
 * [For the Swift example, see here](\ref labelmaker_swift_section).
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor labelmaker_objc_section
 *
 * @include Objective-C/TestLabelMakerSDK/TestLabelMakerSDK/main.m
 * @subsection Swift Swift:
 * @anchor labelmaker_swift_section
 *
 * @include Swift/TestLabelMakerSDK/TestLabelMakerSDK/main.swift
 */

/**
 * @defgroup Interface
 * @ingroup LabelMaker
 * @brief Interface for different barcode types and formats.
 */

/**
 * @defgroup PGL
 * @ingroup LabelMaker
 * @brief
 * Interface for different barcode types and formats.
 */

/**
 * @defgroup TSPL
 * @ingroup LabelMaker
 * @brief Interface for different barcode types and formats.
 */


/**
 * @defgroup Mgmt
 * @brief Classes and methods related to JSONMng.
 * @details
 * [For the Objective-C  example, see here](\ref mgmt_objc_section).
 *
 * [For the Swift example, see here](\ref mgmt_swift_section).
 * @section Example
 * @subsection Objective-C Objective-C:
 * @anchor mgmt_objc_section
 *
 * @include Objective-C/TestMgmtCommSDK/TestMgmtCommSDK/main.m
 * @subsection Swift Swift:
 * @anchor mgmt_swift_section
 *
 * @include Swift/TestMgmtCommSDK/TestMgmtCommSDK/main.swift
 */

/**
 * @defgroup Monitor
 * @brief Classes and methods related to Monitor.
 * @details
 * For the Objective-C  example:
 *
 * [Printer Monitor example](\ref printermonitor_objc_section)
 *
 * [Rfid Monitor exmaple](\ref rfidmonitor_objc_section)
 *
 * [Odv Monitor exmaple](\ref odvmonitor_objc_section)
 *
 * For the Swift example:
 *
 * [Printer Monitor example](\ref printermonitor_swift_section)
 *
 * [Rfid Monitor exmaple](\ref rfidmonitor_swift_section)
 *
 * [Odv Monitor exmaple](\ref odvmonitor_swift_section)
 *
 * @section Example
 * @subsection Objective-C Objective-C:
 * @subsection PrinterMonitor Printer Monitor:
 * @anchor printermonitor_objc_section
 *
 * @include Objective-C/TestPrinterMonitor/TestPrinterMonitor/main.m
 * @subsection RfidMonitor Rfid Monitor:
 * @anchor rfidmonitor_objc_section
 *
 * @include Objective-C/TestRfidMonitor/TestRfidMonitor/main.m
 * @subsection OdvMonitor Odv Monitor:
 * @anchor odvmonitor_objc_section
 *
 * @include Objective-C/TestOdvMonitor/TestOdvMonitor/main.m
 *
 * @subsection Swidt Swift:
 * @subsection PrinterMonitorS Printer Monitor:
 * @anchor printermonitor_swift_section
 *
 * @include Swift/TestPrinterMonitor/TestPrinterMonitor/main.swift
 * @subsection RfidMonitors Rfid Monitor:
 * @anchor rfidmonitor_swift_section
 *
 * @include Swift/TestRfidMonitor/TestRfidMonitor/main.swift
 * @subsection OdvMonitors Odv Monitor:
 * @anchor odvmonitor_swift_section
 *
 * @include Swift/TestOdvMonitor/TestOdvMonitor/main.swift
 */

/**
 * @defgroup Reports
 * @brief Classes and methods related to Reports.
 */

/**
 * @defgroup Settings
 * @brief Support for reading and writing printer cofigurations.
 */















#endif /* Documentation_h */
