//
//  IRfidBankSelect.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IRfidBankSelect_h
#define IRfidBankSelect_h

// IRfidBankSelect.h
#import <Foundation/Foundation.h>
#import <UniPRT/RfidMemBlockEnum.h>

/**
 * @~english
 * @protocol IRfidBankSelect
 *
 * @brief A protocol defining the interface for RfidBankSelect classes.
 *
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IRfidBankSelect
 *
 * @brief 定义 RfidBankSelect 类接口的协议。
 *
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol IRfidBankSelect
 *
 * @brief 定義 RfidBankSelect 類接口的協議。
 *
 * @ingroup Interface
 */
@protocol IRfidBankSelect <NSObject>

/**
 * @~english
 * @brief The memory type to access. Note that not all memory types are writable. For example, the TID (Tag Identification) is typically read-only.
 *
 * @~chinese
 * @brief 要访问的内存类型。请注意，并非所有内存类型都是可写的。例如，TID（标签识别）通常是只读的。
 *
 * @~Chinese-Traditional
 * @brief 要訪問的內存類型。請注意，並非所有內存類型都是可寫的。例如，TID（標籤識別）通常是只讀的。
 */
@property (nonatomic, assign) RfidMemBlockEnum memory;

@end

#endif /* IRfidBankSelect_h */
