//
//  UsbConnection.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/3/21.
//
#import <Foundation/Foundation.h>
#import <IOKit/usb/IOUSBLib.h>
#import <UniPRT/UsbInterfaceInfo.h>
#import <UniPRT/AComm.h>

/**
 * @class UsbConnection
 * @brief A class for managing USB connections.
 * @ingroup Comm
 *
 * @class UsbConnection
 * @brief 用于管理USB连接的类。
 * @ingroup Comm
 *
 * @class UsbConnection
 * @brief 用於管理USB連接的類。
 * @ingroup Comm
 */
@interface UsbConnection : NSObject

/**
 * @brief Retrieves a list of available USB devices.
 *
 * @brief 获取可用USB设备的列表。
 *
 * @brief 獲取可用USB設備的列表。
 *
 * @return An array of arrays, where each sub-array contains information about an available USB device.
 *
 * @return 一个包含数组的数组，每个子数组包含有关可用USB设备的信息。
 *
 * @return 一個包含陣列的陣列，每個子陣列包含有關可用USB設備的信息。
 */
- (NSArray<NSArray *> *)availableDevices;

@end
