//
//  Translate.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/15.
//

#ifndef Translate_h
#define Translate_h

#import <Foundation/Foundation.h>

#import <AutoIdSDK/TSPL.h>
#import <AutoIdSDK/QRCodeModelEnum.h>
#import <AutoIdSDK/QRCodeErrorCorrectionEnum.h>
#import <AutoIdSDK/QRCodeManualEncodingEnum.h>
#import <AutoIdSDK/RfidMemBlockEnum.h>
#import <AutoIdSDK/RfidPasswordTypeEnum.h>
#import <AutoIdSDK/RotateEnum.h>
#import <AutoIdSDK/AlignEnum.h>
#import <AutoIdSDK/BarcodeTypeEnum_1D.h>

@interface Translate : NSObject

+ (TSPLRotation)rotationWithEnum:(RotateEnum)rotation;
+ (TSPLAlignEnum)alignmentWithEnum:(AlignEnum)align;
+ (TSPLBarcodeType1D)barcodeType1DWithEnum:(BarcodeTypeEnum1D)barcodeType;
+ (int)qrCodeModelWithEnum:(QRCodeModelEnum)model;
+ (int)qrCodeErrCorrectionWithEnum:(QRCodeErrorCorrectionEnum)errCorr;
+ (char)qrCodeEncodingWithEnum:(QRCodeManualEncodingEnum)manualEncodeType;
+ (NSString *)rfidMemBlockWithEnum:(RfidMemBlockEnum)memBlockSelect;
+ (NSString *)rfidLockTypeWithEnum:(RfidPasswordTypeEnum)lockType;

@end

#endif /* Translate_h */
