//
//  UsbConnection.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/3/21.
//
#import <Foundation/Foundation.h>
#import <IOKit/usb/IOUSBLib.h>
#import <AutoIdSDK/UsbInterfaceInfo.h>
#import <AutoIdSDK/Acomm.h>

/**
 * @class UsbConnection
 * @brief A class for managing USB connections.
 * @ingroup Comm
 */
@interface UsbConnection : NSObject

/**
 * @brief Retrieves a list of available USB devices.
 *
 * @return An array of arrays, where each sub-array contains information about an available USB device.
 */
- (NSArray<NSArray *> *)availableDevices;

@end
