//
//  UsbInterfaceInfo.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/3/12.
//
#import <IOKit/usb/IOUSBLib.h>

#ifndef UsbInterfaceInfo_h
#define UsbInterfaceInfo_h


#endif /* UsbInterfaceInfo_h */

/**
 * @class UsbInterfaceInfo
 * @brief A class that holds information about a USB interface.
 * @ingroup Comm
 */
@interface UsbInterfaceInfo : NSObject

/**
 * @brief A pointer to the USB interface.
 */
@property (nonatomic, assign) IOUSBInterfaceInterface **interface;

/**
 * @brief The vendor ID of the USB interface.
 */
@property (nonatomic, assign) int interfaceVendorId;

/**
 * @brief The product ID of the USB interface.
 */
@property (nonatomic, assign) int interfaceProductId;

/**
 * @brief The packet size of the output endpoint of the USB interface.
 */
@property (nonatomic, assign) int interfaceOutEndpointPacketSize;

/**
 * @brief The packet size of the input endpoint of the USB interface.
 */
@property (nonatomic, assign) int interfaceInEndpointPacketSize;

/**
 * @brief The data received from the USB interface.
 */
@property (strong, nonatomic) NSMutableData *receivedData;

/**
 * @brief A flag indicating whether there are bytes available to read.
 */
@property (assign, nonatomic) BOOL bytesAvailable;

@end

