//
//  PglMaxicodeBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/27.
//

#ifndef PglMaxicodeBarcode_h
#define PglMaxicodeBarcode_h

#import <Foundation/Foundation.h>
#import <UniPRT/AMaxicodeBarcode.h>
#import <UniPRT/IRotation.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/IMaxicodeData.h>

/**
 * \~English
 * @class PglMaxicodeBarcode
 * @brief A class representing a Maxicode barcode.
 *
 * This class inherits from AMaxicodeBarcode and implements the IRotation protocol,
 * providing functionality for initializing and describing Maxicode barcodes.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglMaxicodeBarcode
 * @brief 表示Maxicode条形码的类。
 *
 * 该类继承自AMaxicodeBarcode并实现了IRotation协议，提供了初始化和描述Maxicode条形码的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglMaxicodeBarcode
 * @brief 表示Maxicode條形碼的類。
 *
 * 該類繼承自AMaxicodeBarcode並實現了IRotation協議，提供了初始化和描述Maxicode條形碼的功能。
 *
 * @ingroup PGL
 */
@interface PglMaxicodeBarcode : AMaxicodeBarcode <IRotation>

/**
 * \~English
 * @brief The starting point of the barcode.
 *
 * \~Chinese
 * @brief 条形码的起始点。
 *
 * \~Chinese-Traditional
 * @brief 條形碼的起始點。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * \~English
 * @brief The data to be encoded in the barcode.
 *
 * \~Chinese
 * @brief 要编码到条形码中的数据。
 *
 * \~Chinese-Traditional
 * @brief 要編碼到條形碼中的數據。
 */
@property (nonatomic, strong) id<IMaxicodeData> data;

/**
 * \~English
 * @brief The rotation of the barcode.
 *
 * \~Chinese
 * @brief 条形码的旋转。
 *
 * \~Chinese-Traditional
 * @brief 條形碼的旋轉。
 */
@property (nonatomic, assign) RotateEnum rotation;

/**
 * \~English
 * @brief Zipper pattern can be used to help detect printing defects e.g. light/dark printing.
 *
 * \~Chinese
 * @brief 拉链图案可以帮助检测打印缺陷，例如浅色/深色打印。
 *
 * \~Chinese-Traditional
 * @brief 拉鏈圖案可以幫助檢測打印缺陷，例如淺色/深色打印。
 */
@property (nonatomic, assign) BOOL zipperPattern;

/**
 * \~English
 * @brief Initializes a new instance of the PglMaxicodeBarcode class with specified start point and data.
 *
 * @param start The starting point of the barcode.
 * @param data The data to be encoded in the barcode.
 * @return A new instance of PglMaxicodeBarcode.
 *
 * \~Chinese
 * @brief 使用指定的起始点和数据初始化PglMaxicodeBarcode类的新实例。
 *
 * @param start 条形码的起始点。
 * @param data 要编码到条形码中的数据。
 * @return PglMaxicodeBarcode的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點和數據初始化PglMaxicodeBarcode類的新實例。
 *
 * @param start 條形碼的起始點。
 * @param data 要編碼到條形碼中的數據。
 * @return PglMaxicodeBarcode的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start data:(id<IMaxicodeData>)data;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the PglMaxicodeBarcode instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing.
 *
 * @return A string description of the PglMaxicodeBarcode instance.
 *
 * \~Chinese
 * @brief 返回一个可以发送到打印机的字符串。
 *
 * 该方法生成一个PglMaxicodeBarcode实例的字符串表示形式，该字符串已格式化并可以发送到打印机。字符串包括打印所需的所有命令和数据。
 *
 * @return PglMaxicodeBarcode实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回一個可以發送到打印機的字符串。
 *
 * 該方法生成一個PglMaxicodeBarcode實例的字符串表示形式，該字符串已格式化並可以發送到打印機。字符串包括打印所需的所有命令和數據。
 *
 * @return PglMaxicodeBarcode實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* PglMaxicodeBarcode_h */
