//
//  Setting.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/14.
//

#ifndef Setting_h
#define Setting_h


#endif /* Setting_h */

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class Setting
 * @brief A class representing a configurable setting with various properties.
 * @ingroup Settings
 *
 * \~Chinese
 * @class Setting
 * @brief 表示具有各种属性的可配置设置的类。
 * @ingroup Settings
 *
 * \~Chinese-Traditional
 * @class Setting
 * @brief 表示具有各種屬性的可配置設置的類。
 * @ingroup Settings
 */
@interface Setting : NSObject

/**
 * \~English
 * @brief The type of the setting.
 *
 * \~Chinese
 * @brief 设置的类型。
 *
 * \~Chinese-Traditional
 * @brief 設置的類型。
 */
@property (nonatomic, strong) NSString *type;

/**
 * \~English
 * @brief The permission level of the setting (e.g., read-only, read-write).
 *
 * \~Chinese
 * @brief 设置的权限级别（例如，只读，读写）。
 *
 * \~Chinese-Traditional
 * @brief 設置的權限級別（例如，只讀，讀寫）。
 */
@property (nonatomic, strong) NSString *permission;

/**
 * \~English
 * @brief The value of the setting.
 *
 * \~Chinese
 * @brief 设置的值。
 *
 * \~Chinese-Traditional
 * @brief 設置的值。
 */
@property (nonatomic, strong) NSString *value;

/**
 * \~English
 * @brief The minimum allowable value for the setting.
 *
 * \~Chinese
 * @brief 设置的最小允许值。
 *
 * \~Chinese-Traditional
 * @brief 設置的最小允許值。
 */
@property (nonatomic, assign) double minimum;

/**
 * \~English
 * @brief The maximum allowable value for the setting.
 *
 * \~Chinese
 * @brief 设置的最大允许值。
 *
 * \~Chinese-Traditional
 * @brief 設置的最大允許值。
 */
@property (nonatomic, assign) double maximum;

/**
 * \~English
 * @brief The increment value for the setting.
 *
 * \~Chinese
 * @brief 设置的增量值。
 *
 * \~Chinese-Traditional
 * @brief 設置的增量值。
 */
@property (nonatomic, assign) double increment;

/**
 * \~English
 * @brief For "Enum" type only. List of valid values.
 *
 * \~Chinese
 * @brief 仅适用于 "Enum" 类型。有效值列表。
 *
 * \~Chinese-Traditional
 * @brief 僅適用於 "Enum" 類型。有效值列表。
 */
@property (nonatomic, strong) NSArray<NSString *> *options;

/**
 * \~English
 * @brief Converts the setting properties to a string representation.
 *
 * @return A string that represents the setting.
 *
 * \~Chinese
 * @brief 将设置属性转换为字符串表示形式。
 *
 * @return 表示设置的字符串。
 *
 * \~Chinese-Traditional
 * @brief 將設置屬性轉換為字符串表示形式。
 *
 * @return 表示設置的字符串。
 */
- (NSString *)description;

@end
