//
//  IFontSizeUnits.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IFontSizeUnits_h
#define IFontSizeUnits_h

// IFontSizeUnits.h
#import <Foundation/Foundation.h>
#import <UniPRT/FontSizeUnitsEnum.h>

/**
 * \~English
 * @protocol IFontSizeUnits
 * @brief A protocol defining the interface for FontSizeUnits classes.
 * @ingroup Interface
 *
 * This protocol defines the interface for classes that handle font size units. It allows for selecting character sizing between font points or other sizing units.
 *
 * \~Chinese
 * @protocol IFontSizeUnits
 * @brief 定义FontSizeUnits类的接口的协议。
 * @ingroup Interface
 *
 * 此协议定义了处理字体大小单位的类的接口。它允许在字体点或其他尺寸单位之间选择字符大小。
 *
 * \~Chinese-Traditional
 * @protocol IFontSizeUnits
 * @brief 定義FontSizeUnits類的接口的協議。
 * @ingroup Interface
 *
 * 此協議定義了處理字體大小單位的類的接口。它允許在字體點或其他尺寸單位之間選擇字符大小。
 */

/**
 * \~English
 * @brief Character sizing select between using font points or other sizing unit.
 *
 * For X/Y char size is in terms of font points, 1 point = 1/72 inch (~0.35 mm).
 *
 * Note that some fonts may not be scalable. Any values specified outside of minimum/maximum ranges will be limited to the minimum or maximum.
 *
 * \~Chinese
 * @brief 字符大小选择使用字体点或其他大小单位。
 *
 * 对于X/Y字符大小，以字体点为单位，1点 = 1/72英寸（约0.35毫米）。
 *
 * 请注意，有些字体可能无法缩放。任何指定的值如果超出最小/最大范围，将被限制为最小或最大值。
 *
 * \~Chinese-Traditional
 * @brief 字符大小選擇使用字體點或其他大小單位。
 *
 * 對於X/Y字符大小，以字體點為單位，1點 = 1/72英寸（約0.35毫米）。
 *
 * 請注意，有些字體可能無法縮放。任何指定的值如果超出最小/最大範圍，將被限制為最小或最大值。
 */
@protocol IFontSizeUnits <NSObject>

@property (nonatomic, assign) FontSizeUnitsEnum fontSizeUnits; ///< \~English Font size units for character sizing. \~Chinese 字符大小的字体单位。 \~Chinese-Traditional 字符大小的字體單位。

@end

#endif /* IFontSizeUnits_h */
