//
//  AQRBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef AQRBarcode_h
#define AQRBarcode_h

#import <Foundation/Foundation.h>

#import <AutoIdSDK/ABarcode2D.h>
#import <AutoIdSDK/ISquareCell.h>
#import <AutoIdSDK/QRCodeMaskEnum.h>
#import <AutoIdSDK/QRCodeModelEnum.h>
#import <AutoIdSDK/QRCodeErrorCorrectionEnum.h>

@interface AQRBarcode : ABarcode2D <ISquareCell>

@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, strong) NSArray<NSArray *> *dataManuallyEncoded; // Array of tuples replaced by NSArray of NSArrays
@property (nonatomic, assign) QRCodeMaskEnum mask;
@property (nonatomic, assign) QRCodeModelEnum model;
@property (nonatomic, assign) QRCodeErrorCorrectionEnum errorCorrection;
@property (nonatomic, strong) id<ICellSquare> cellSize;

- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;
- (instancetype)initWithStart:(id<IPoint>)start manuallyEncodedData:(NSArray<NSArray *> *)dataManuallyEncoded;

@end

#endif /* AQRBarcode_h */
