//
//  UsbInterfaceInfo.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/3/12.
//
#import <IOKit/usb/IOUSBLib.h>

#ifndef UsbInterfaceInfo_h
#define UsbInterfaceInfo_h


#endif /* UsbInterfaceInfo_h */

/**
 * @class UsbInterfaceInfo
 * @brief A class that holds information about a USB interface.
 * @ingroup Comm
 *
 * @class UsbInterfaceInfo
 * @brief 存储USB接口信息的类。
 * @ingroup Comm
 *
 * @class UsbInterfaceInfo
 * @brief 儲存USB接口信息的類。
 * @ingroup Comm
 */
@interface UsbInterfaceInfo : NSObject

/**
 * @brief A pointer to the USB interface.
 *
 * @brief 指向USB接口的指针。
 *
 * @brief 指向USB接口的指針。
 */
@property (nonatomic, assign) IOUSBInterfaceInterface **interface;

/**
 * @brief The vendor ID of the USB interface.
 *
 * @brief USB接口的厂商ID。
 *
 * @brief USB接口的廠商ID。
 */
@property (nonatomic, assign) int interfaceVendorId;

/**
 * @brief The product ID of the USB interface.
 *
 * @brief USB接口的产品ID。
 *
 * @brief USB接口的產品ID。
 */
@property (nonatomic, assign) int interfaceProductId;

/**
 * @brief The packet size of the output endpoint of the USB interface.
 *
 * @brief USB接口输出端点的包大小。
 *
 * @brief USB接口輸出端點的包大小。
 */
@property (nonatomic, assign) int interfaceOutEndpointPacketSize;

/**
 * @brief The packet size of the input endpoint of the USB interface.
 *
 * @brief USB接口输入端点的包大小。
 *
 * @brief USB接口輸入端點的包大小。
 */
@property (nonatomic, assign) int interfaceInEndpointPacketSize;

/**
 * @brief The data received from the USB interface.
 *
 * @brief 从USB接口接收的数据。
 *
 * @brief 從USB接口接收的數據。
 */
@property (strong, nonatomic) NSMutableData *receivedData;

/**
 * @brief A flag indicating whether there are bytes available to read.
 *
 * @brief 指示是否有可读字节的标志。
 *
 * @brief 指示是否有可讀字節的標誌。
 */
@property (assign, nonatomic) BOOL bytesAvailable;

@end
