import threading
from typing import Optional, Callable, Dict
from .CancellationToken import CancellationToken
from .JsonMng import JsonComm


class RfidReport:
    def __init__(self) -> None: ...
    raw_report: Dict[str, str]

    def failed(self) -> bool: ...
    def data(self) -> str: ...
    def data_type(self) -> str: ...
    def is_write_operation(self) -> bool: ...
    def set_raw_report(self, raw_report: Dict[str, str]) -> None: ...


class RfidMonitor:
    def __init__(self, connection: Optional[JsonComm] = None, mgmt_comm: Optional[JsonComm] = None, comm_descriptor: Optional[str] = None) -> None: ...
    def init_with_tcp_comm(self, connection: JsonComm) -> None: ...
    def init_with_json_comm(self, mgmt_comm: JsonComm) -> None: ...
    def init_with_comm_descriptor(self, comm_descriptor: str) -> None: ...
    def is_report_complete(self, rpt_to_check: Dict[str, str]) -> bool: ...
    def print_rpt_to_check(self, rpt_to_check: Dict[str, str]) -> bool: ...
    def concatenate_reports(self, partial_rpt: Dict[str, str], new_rpt_data: Dict[str, str]) -> None: ...
    def set_callback_for_rfid_report(self, callback: Callable[[RfidReport], None]) -> None: ...
    def set_rfid_report_listening(self, value: bool) -> None: ...
    def stop_listening_thread(self) -> None: ...
