from enum import Enum
from typing import Protocol, List, Tuple, Optional
from .ICoordinates import IPoint, IRuler
from .ISettings import RotateEnum, IRotation

class IBarcodeItem2D(Protocol):
    start: IPoint
    data: str

class ICellSquare(Protocol):
    ruler: IRuler
    xdim: float

class ICellRect(ICellSquare, Protocol):
    ydim: float

class IStartPoint(Protocol):
    start: IPoint

class IPositionRuler(Protocol):
    ruler: IRuler

class ISquareCell(Protocol):
    cell_size: ICellSquare

class IRectangleCell(Protocol):
    cell_size: ICellRect

class IBarcode2D(IBarcodeItem2D, IPositionRuler, IRotation, Protocol):
    def __str__(self) -> str: ...

class ACellSquare(ICellSquare):
    def __init__(self, xdim: float = 0.0, ruler: Optional[IRuler] = None) -> None: ...
    ruler: Optional[IRuler]
    xdim: float

class CellSquare(ACellSquare):
    def __init__(self, xdim: float = 0.0, ruler: Optional[IRuler] = None) -> None: ...

class CellRect(ACellSquare, ICellRect):
    def __init__(self, xdim: float = 0.0, ydim: float = 0.0, ruler: Optional[IRuler] = None) -> None: ...
    ydim: float

class ABarcode2D(IBarcode2D):
    def __init__(self, start: Optional[IPoint] = None, data: str = "", ruler: Optional[IRuler] = None, rotation: RotateEnum = RotateEnum.NONE) -> None: ...
    start: Optional[IPoint]
    data: str
    ruler: IRuler
    rotation: RotateEnum

    def __str__(self) -> str: ...

class ADataMatrix(ABarcode2D, ISquareCell):
    def __init__(self, start: Optional[IPoint] = None, data: str = "", cell_size: Optional[ICellSquare] = None) -> None: ...
    rows_cols: Tuple[int, int]
    cell_size: ICellSquare
    rectangle: bool

    def ctrl_char(self, decimal_char_value: int) -> str: ...
    @property
    def fnc1(self) -> str: ...
