from enum import Enum
from typing import Protocol, Optional
from .IBarcode2D import ICellSquare, ISquareCell, ABarcode2D
from .ICoordinates import IPoint

class AztecCodeTypeEnum(Enum):
    DEFAULT = 0
    FIXED_ERR_CORRECTION = 1
    COMPACT = 2
    FULL = 3
    RUNE = 4

class AAztecBarcode(ABarcode2D, ISquareCell):
    cell_size: Optional[ICellSquare]
    type: AztecCodeTypeEnum
    layers: int
    fixed_err_correction: int
    start: Optional[IPoint]
    data: Optional[str]
