from enum import Enum
from typing import Protocol, Optional

class ScaleEnum(Enum):
    DOT = 0
    MM = 1
    INCH = 2

class IRuler(Protocol):
    scale: ScaleEnum

class IPair(Protocol):
    x: float
    y: float

class IPoint(IPair, Protocol):
    pass

class IPrintResolution(Protocol):
    dots_per_inch: float
    dots_per_mm: float

class IPrintPlane(Protocol):
    printer_resolution: IPrintResolution
    ruler: IRuler
    

class Points(IPoint):
    def __init__(self, x: float, y: float): ...

class PrintResolution(IPrintResolution):
    def __init__(self, dots_per_unit: float, unit: ScaleEnum): ...
    def set_dots_per_inch(self, dots_per_inch: float): ...
    def set_dots_per_mm(self, dots_per_mm: float): ...

class PrintPlane(IPrintPlane):
    def __init__(self, ruler: Optional[IRuler] = None, print_resolution: Optional[IPrintResolution] = None): ...