from abc import ABC, abstractmethod
from typing import Protocol, Optional
from .ICoordinates import IPoint, IRuler


class ILine(Protocol):
    """
    @protocol ILine
    @brief A protocol defining the interface for Line classes.
    @ingroup Interface
    """
    ruler: Optional[IRuler]
    start: IPoint
    end: IPoint
    line_thickness: float


class IBox(Protocol):
    """
    @protocol IBox
    @brief A protocol defining the interface for Box classes.
    @ingroup Interface
    """
    ruler: Optional[IRuler]
    start: IPoint
    end: IPoint
    line_thickness: float
    corner_rounding: float


class ALine(ILine):
    """
    @class ALine
    @brief Base class for ALine.
    @ingroup Interface
    """
    def __init__(self, start: IPoint, end: IPoint, line_thickness: float):
        self.start = start
        self.end = end
        self.line_thickness = line_thickness
        self.ruler: Optional[IRuler] = None  # Default to None, can be set up later if needed

    def __str__(self) -> str:
        return f"ALine: start=({self.start.x},{self.start.y}), end=({self.end.x},{self.end.y}), line_thickness={self.line_thickness}"
