from typing import Optional
from ..Interfaces.ICoordinates import IPoint
from ..Interfaces.IShapes import ALine, IBox

class Line(ALine):
    def __init__(
        self,
        start: Optional[IPoint] = None,
        end: Optional[IPoint] = None,
        line_thickness: float = 1.0,
    ) -> None: ...

    @classmethod
    def from_coordinates(
        cls,
        x_start: float,
        y_start: float,
        x_end: float,
        y_end: float,
        line_thickness: float = 1.0,
    ) -> "Line": ...

    def __str__(self) -> str: ...


class Box(IBox):
    def __init__(
        self,
        start: Optional[IPoint] = None,
        end: Optional[IPoint] = None,
        line_thickness: float = 1.0,
    ) -> None: ...

    @classmethod
    def from_coordinates(
        cls,
        x_start: float,
        y_start: float,
        x_end: float,
        y_end: float,
        line_thickness: float = 1.0,
    ) -> "Box": ...

    def __str__(self) -> str: ...
