from typing import Optional
from .ICoordinates import IPrintResolution, IRuler, ScaleEnum, PrintResolution, DEFAULT_DPI
from .ISettings import AlignEnum, RotateEnum
from .IBarcode2D import ICellSquare, ICellRect, CellRect, CellSquare
from .Coordinate import Ruler

class Defaults:
    _printer_resolution: Optional[IPrintResolution] = None
    _ruler: Optional[IRuler] = None
    _alignment: AlignEnum = AlignEnum.LEFT
    _rotation: RotateEnum = RotateEnum.NONE
    _cell_size: Optional[ICellSquare] = None
    _cell_size_rect: Optional[ICellRect] = None
    
    @classmethod
    def set_printer_resolution(cls, printer_resolution: IPrintResolution) -> None: ...
    
    @classmethod
    def set_ruler(cls, ruler: IRuler) -> None: ...
    
    @classmethod
    def set_alignment(cls, alignment: AlignEnum) -> None: ...
    
    @classmethod
    def set_rotation(cls, rotation: RotateEnum) -> None: ...
    
    @classmethod
    def set_cell_size(cls, cell_size: ICellSquare) -> None: ...
    
    @classmethod
    def set_cell_size_rect(cls, cell_size_rect: ICellRect) -> None: ...
