from enum import Enum
from typing import Protocol, List, Optional
from .ICoordinates import IPoint, IRuler
from .ISettings import IRotation, RotateEnum
from .Coordinate import Points

class BarcodeTypeEnum1D(Enum):
    NOT_DEFINED = 0
    CODE93 = 1
    CODE39 = 2
    CODE128 = 3
    EAN13 = 4
    EAN8 = 5
    UPCA = 6
    I2OF5 = 7
    CODABAR = 8

class IBarcodeType1D(Protocol):
    barcode_type: BarcodeTypeEnum1D

class IBarcodeItem(Protocol):
    start: IPoint
    height: float
    data: str

class ABarcodeItem(IBarcodeItem):
    def __init__(self, start: IPoint, data: str) -> None: ...
    start: IPoint
    height: float
    data: str

class BarcodeItem(ABarcodeItem):
    def __init__(self, start: Optional[IPoint] = None, data: Optional[str] = None, height: Optional[float] = None) -> None: ...
    
    @classmethod
    def from_coordinates(cls, x_start: float, y_start: float, data: str, height: Optional[float] = None) -> "BarcodeItem": ...

class IBarWidths(Protocol):
    ruler: IRuler
    narrow_bar: float
    wide_bar: float

class ABarWidths(IBarWidths):
    def __init__(self, narrow_bar: float, wide_bar: float) -> None: ...
    ruler: Optional[IRuler]
    narrow_bar: float
    wide_bar: float

class IBarcode1DProperties(IRotation, IBarcodeType1D, Protocol):
    ruler: IRuler
    bar_widths: IBarWidths
    print_human_readable: bool

class IBarcode1D(IBarcode1DProperties, Protocol):
    barcodes: List[IBarcodeItem]

    def __str__(self) -> str: ...

class ABarcode1D(IBarcode1D):
    def __init__(self, barcode_item: Optional[IBarcodeItem] = None) -> None: ...
    barcodes: List[IBarcodeItem]
    barcode_type: BarcodeTypeEnum1D
    ruler: Optional[IRuler]
    bar_widths: Optional[IBarWidths]
    print_human_readable: bool
    rotation: RotateEnum

    def __str__(self) -> str: ...
