from enum import Enum
from typing import Protocol, Optional
from .ICoordinates import IPoint, IRuler
from .IBarcode2D import IStartPoint, IPositionRuler

class MaxicodeModeEnum(Enum):
    MODE2 = 2
    MODE3 = 3
    MODE4 = 4

class IMaxicodeData(Protocol):
    mode: MaxicodeModeEnum
    data: str

class IMaxicodeMsgStructured(IMaxicodeData, Protocol):
    postal_code: str
    country_code: str
    service_class: str
    remaining_msg: str

class IMaxicodeMsgStructuredOpenSystemStandard(IMaxicodeData, Protocol):
    postal_code: str
    country_code: str
    service_class: str
    year: str
    remaining_msg: str

class IMaxicodeMsg(IMaxicodeData, Protocol):
    primary_msg: str
    remaining_msg: str

class IMaxicodeBarcode(IStartPoint, IPositionRuler, Protocol):
    data: IMaxicodeData
    start: IPoint
    ruler: IRuler

    def __str__(self) -> str: ...

class AMaxicodeMsgStructured(IMaxicodeMsgStructured):
    @property
    def data(self) -> str: ...

class AMaxicodeMsgStructuredOpenSystemStandard(IMaxicodeMsgStructuredOpenSystemStandard):
    @property
    def data(self) -> str: ...

class AMaxicodeMsg(IMaxicodeMsg):    
    @property
    def data(self) -> str: ...

class AMaxicodeBarcode(IMaxicodeBarcode):    
    def __str__(self) -> str: ...
