import CommSDK
import ctypes
import threading
import time

Comm_Sdk_Instance = CommSDK.CommSDK()

Connected = False
_bAsyncListening = False
listenerThread = None
currentText = ""
file_path = ""
mutex = threading.Lock()
comboIdx = -1


def ListenerAsync():

    global Connected
    global _bAsyncListening
    global mutex
    global currentText


    while _bAsyncListening and Connected:
    
      time.sleep(0.5) # Sleep for 500 milliseconds
     
      if not _bAsyncListening:
            break

      with mutex:
        iBytes = Comm_Sdk_Instance.GetBytesAvailable()

        
        if not _bAsyncListening:
            break

        
        if iBytes > 0:
            pBuf = (ctypes.c_byte * iBytes)()
            Comm_Sdk_Instance.Read(pBuf, iBytes)

            
            if not _bAsyncListening:
                break

            char_str = ctypes.cast(pBuf, ctypes.c_char_p).value.decode('utf-8', errors='ignore')
            char_str = char_str[:iBytes]
            if (len(char_str)):
                currentText += char_str
                print("Response:")
                print(currentText)
                currentText = ""

        else:
            time.sleep(0.01)  # Sleep for 10 milliseconds

    return





def on_AsyncListen():
    global _bAsyncListening
    global listenerThread
    global Connected
   
    if _bAsyncListening:
        print("---Deactivate Listener")
        _bAsyncListening = False
        Comm_Sdk_Instance.StopAsyncListening()
        
        
        if listenerThread and listenerThread.is_alive():
           listenerThread.join()

    else:
        if not Connected:
            print("Connect first. Can't listen without a valid open/active connection.")
            return

        _bAsyncListening = True

        # Start the async listener thread
        listenerThread = threading.Thread(target=ListenerAsync)
        listenerThread.start()
        time.sleep(1)
    return


def main():
   
    global _bAsyncListening
    global Connected

    Comm_Sdk_Instance.TcpConnection("10.0.10.173", 9100)

    Comm_Sdk_Instance.Open()
    if Comm_Sdk_Instance.Connected():
        Connected = True
        content = ""
        
        #Print job
        content += "SIZE 3,2\r\n"
        content += "GAP 0 mm, 0 mm\r\n"
        content += "DIRECTION 1\r\n"
        content += "CLS\r\n"
        content += "TEXT 10, 30, \"3\", 0, 1, 1, \"123456\"\r\n"
        content += "BARCODE 10, 100, \"EAN13\", 80, 1, 0, 2, 4, \"123456789012\"\r\n"
        content += "TEXT 10, 70, \"4\", 0, 1, 1, \"TEST PRINTOUT\"\r\n"
        content += "PRINT 1, 1\r\n"
        #Print job
        
        
        
    
        """
        #AsyncListen
        on_AsyncListen()
        content += "A$=\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\r\n"
        content += "OUT A$\r\n"
        #AsyncListen
        """


        print()
        print("Send to Printer:")
        print(content)
        charBuffer = content.encode('utf-8')
        Comm_Sdk_Instance.Write(bytearray(charBuffer), len(charBuffer))
        


        
        """
        # WriteAndWaitForResponse
        content = "FEED 100\r\nOUT \"12345678\"\r\n"
        print()
        print("Send to Printer:")
        print(content)
        Length = len(content)
        Str = Comm_Sdk_Instance.WriteAndWaitForResponse(bytearray(content, 'utf-8'), Length, 1000, 500, "\r\n")
        if(Str):
            Response = Str.decode()
            print()
            print("Response")
            print(Response)
        # WriteAndWaitForResponse
        """
        
        
    else:
        print("Failed to Connect Printer")
        return 1
    
    userInput = None

    # 循環等待用戶輸入，直到用戶輸入0為止
    
    while userInput != 0:
        print("\nPress 0 to exit")
        userInput = int(input())
        time.sleep(0.5)

    # 使用者輸入0 後程式結束
    print("\nProgram exit\n")
    
    

    _bAsyncListening = False
    Connected = False
    if Comm_Sdk_Instance.Connected() == True:
          Comm_Sdk_Instance.Close()

    return 0





if __name__ == "__main__":
    main()



