from typing import Dict
import threading
from typing import Optional, Callable, List
from .JsonMng import JsonComm, JsonCommController, CommType, ChannelType, DONT_CARE_ID
from .JsonStringBuilder import JsonStringBuilder
from .JsonStringTokenizer import JsonStringTokenizer
from .CancellationToken import CancellationToken

class PrinterMonitor:
    def __init__(self, connection: Optional[JsonComm] = None, mgmt_comm: Optional[JsonComm] = None, comm_descriptor: Optional[str] = None) -> None: ...

    def msg_parser_printer_info(self, mgmt_report_frame: str) -> Dict[str, str]: ...
    def get_fault_status(self) -> List[str]: ...
    def get_printer_info(self) -> PrinterInfo: ...
    def get_engine_status(self) -> str: ...
    def set_engine_status_callback(self, callback: Callable[[str], None]) -> None: ...
    def set_display_status_callback(self, callback: Callable[[List[str]], None]) -> None: ...
    def set_alert_status_callback(self, callback: Callable[[List[str]], None]) -> None: ...
    def set_engine_status_listening(self, value: bool) -> None: ...
    def set_display_status_listening(self, value: bool) -> None: ...
    def set_alert_status_listening(self, value: bool) -> None: ...


class PrinterInfo:
    def __init__(self) -> None: ...
    _raw_info: Dict[str, str]

    def set_raw_info(self, raw_info: Dict[str, str]) -> None: ...
    def model(self) -> str: ...
    def firmware_version(self) -> str: ...
    def firmware_part_number(self) -> str: ...
    def has_clock_option(self) -> bool: ...
    def has_odv_option(self) -> bool: ...
    def has_rfid_option(self) -> bool: ...
    def printhead_resolution(self) -> str: ...
    def serial_number(self) -> str: ...


class PrinterUtil:
    @staticmethod
    def ping(ip: str) -> bool: ...
    @staticmethod
    def ping_responded(ip: str, timeout_secs: int) -> bool: ...
    @staticmethod
    def ping_stopped_responding(ip: str, timeout_secs: int) -> bool: ...
