import Foundation
import UniPRT


func main() {
    let ipAddress = "10.0.10.170"
    let tcpComm = TcpComm(ipAddress: ipAddress, port: UInt(DEFAULT_MGMT_PORT))
    tcpComm?.open()

    let odvMonitor = OdvMonitor(tcpComm: tcpComm)
    let printerMonitor = PrinterMonitor(tcpComm: tcpComm)

    var choice = 0
    repeat {
        print("\nMenu:")
        print("1 - Get Printer Info")
        print("2 - Listen to ODVReport")
        print("3 - Print example file")
        print("4 - Exit")
        print("Enter your choice (1-4):")

        if let input = readLine(), let inputNumber = Int(input.trimmingCharacters(in: .whitespacesAndNewlines)) {
            choice = inputNumber
        }

        switch choice {
        case 1:
            let printerInfo = printerMonitor?.getPrinterInfo()
            print("\n======= ODV Printer Info: ")
            print("Printer Model: \(printerInfo?.model() ?? "")")
            print("Printer SN: \(printerInfo?.serialNumber() ?? "")")
            print("Printer FW PN: \(printerInfo?.firmwarePartNumber() ?? "")")
            print("Printer FW Ver: \(printerInfo?.firmwareVersion() ?? "")")
            print("Printhead Resolution (Dots/Inch): \(printerInfo?.printheadResolution() ?? "")")
            print("Has ODV: \((printerInfo?.hasOdvOption() == true) ? "Yes" : "No")")
            
        case 2:
            DispatchQueue.global().async {
                odvMonitor?.odvReportCallback = { report in
                    if report?.failed() == nil {
                        print("\nBarcode Failed.")
                    } else {
                        print("\nBarcode Passed.")
                        let overallGrade = report?.overallGradeAsFloat()
                        if overallGrade ?? 5 > 3.5 {
                            print("Print Quality passed. \n Overall Grade= \(String(format: "%.2f", overallGrade ?? 0))")
                        } else {
                            print("Print Quality Failed. \n Overall Grade= \(String(format: "%.2f", overallGrade ?? 0))")
                        }

                        print("Barcode Symbology: \(String(describing: report?.symbology()))")
                        print("Barcode Data: \(String(describing: report?.data()))")
                    }
                }
                odvMonitor?.setOdvReportListening(true)
            }
            
        case 3:
            let tcpComm2 = TcpComm(ipAddress: "10.0.10.178", port: 9100)
            tcpComm2?.sendPrintFile("10.0.10.178", fileName: "/Users/realbuber/Documents/doc/TestOdvMonitor/DM_PRINTRONIX_1.pgl")
            print("Sending ODV print job...")
            
        case 4:
            print("Exiting...")
            
        default:
            print("Invalid choice. Please enter a number between 1 and 4.")
        }
    } while choice != 4
}

main()
