//
//  JsonCommController.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/8.
//

#ifndef JsonCommController_h
#define JsonCommController_h


#endif /* JsonCommController_h */

#import <Foundation/Foundation.h>
#import <UniPRT/JsonConnection.h>
#import <UniPRT/JsonComm.h>

/** @cond */

/**
 * @class JsonCommController
 * @brief A singleton class for managing JsonComm instances.
 * @ingroup JSONComm
 */
@interface JsonCommController : NSObject

/**
 * @brief Gets the singleton instance of JsonCommController.
 *
 * @return The shared instance of JsonCommController.
 */
+ (instancetype)sharedInstance;

/**
 * @brief Creates a management communication instance with the given communication descriptor.
 *
 * @param commDescriptor The descriptor for the communication instance.
 * @return A new JsonComm instance.
 */
- (JsonComm *)createMgmtCommWithCommDescriptor:(NSString *)commDescriptor;

/**
 * @brief Releases a management communication instance with the given communication descriptor.
 *
 * @param commDescriptor The descriptor for the communication instance to be released.
 */
- (void)releaseMgmtCommWithCommDescriptor:(NSString *)commDescriptor;

/**
 * @brief Gets the user count for the given communication descriptor.
 *
 * @param commDescriptor The descriptor for the communication instance.
 * @return The number of users for the specified communication instance.
 */
- (NSInteger)userCountForCommDescriptor:(NSString *)commDescriptor;

/**
 * @brief Gets the total number of active connections.
 *
 * @return The total number of connections.
 */
- (NSInteger)connectionCount;

/**
 * @brief Gets an array of all communication descriptors.
 *
 * @return An array of strings representing the communication descriptors.
 */
- (NSArray<NSString *> *)descriptors;

@end

/** @endcond */
