//
//  ADataMatrix.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ADataMatrix_h
#define ADataMatrix_h

#import <Foundation/Foundation.h>
#import <AutoIdSDK/ISquareCell.h>
#import <AutoIdSDK/ABarcode2D.h>
#import <AutoIdSDK/IPoint.h>
@interface ADataMatrix : ABarcode2D <ISquareCell>

@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, assign) char ctrlCharDelimiter;
@property (nonatomic, assign) BOOL rectangle;
@property (nonatomic, strong) id<ICellSquare> cellSize;
@property (nonatomic, strong) NSValue *rowsCols; // Use NSValue to hold a tuple of int values
@property (nonatomic, readonly) NSString *fnc1;

- (instancetype)init;
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;
- (NSString *)ctrlChar:(int)decimalCharValue;

@end

#endif /* ADataMatrix_h */
