//
//  Pdf417Encoder.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/14.
//



#import <Foundation/Foundation.h>
#import <AutoIdSDK/Pdf417EncoderTables.h>

typedef NS_ENUM(NSInteger, EncodingControl) {
    EncodingControlAuto,
    EncodingControlByteOnly,
    EncodingControlTextAndByte,
};

typedef NS_ENUM(NSInteger, ErrorCorrectionLevel) {
    ErrorCorrectionLevel_0,
    ErrorCorrectionLevel_1,
    ErrorCorrectionLevel_2,
    ErrorCorrectionLevel_3,
    ErrorCorrectionLevel_4,
    ErrorCorrectionLevel_5,
    ErrorCorrectionLevel_6,
    ErrorCorrectionLevel_7,
    ErrorCorrectionLevel_8,
    ErrorCorrectionLevelAutoLow,
    ErrorCorrectionLevelAutoNormal,
    ErrorCorrectionLevelAutoMedium,
    ErrorCorrectionLevelAutoHigh,
};

typedef NS_ENUM(NSInteger, EncodingMode) {
    EncodingModeByte,
    EncodingModeText,
    EncodingModeNumeric,
};

typedef NS_ENUM(NSInteger, TextEncodingMode) {
    TextEncodingModeUpper,
    TextEncodingModeLower,
    TextEncodingModeMixed,
    TextEncodingModePunct,
    TextEncodingModeShiftUpper,
    TextEncodingModeShiftPunct,
};

@interface Pdf417Encoder : NSObject

@property (nonatomic) EncodingControl encodingControl;
@property (nonatomic) ErrorCorrectionLevel errorCorrection;
@property (nonatomic) int narrowBarWidth;
@property (nonatomic) int rowHeight;
@property (nonatomic) int quietZone;
@property (nonatomic) int defaultDataColumns;
@property (nonatomic, strong) NSString *globalLabelIDCharacterSet;
@property (nonatomic) int globalLabelIDUserDefined;
@property (nonatomic) int globalLabelIDGeneralPurpose;

@property (nonatomic, strong) NSMutableArray<NSNumber *> *dataCodewords;
@property (nonatomic) int barcodeDataPos;
@property (nonatomic) int barcodeDataLength;
@property (nonatomic, strong) NSData *barcodeBinaryData;
@property (nonatomic) EncodingMode encodingMode;
@property (nonatomic) TextEncodingMode textEncodingMode;
@property (nonatomic) ErrorCorrectionLevel errorCorrectionLevel;
@property (nonatomic) int errorCorrectionLength;

- (void)SetErrorCorrectionLevel;
- (void)dataEncoding;
- (void)encodeNumericSegment:(int)totalCount;
- (int)countDigits;
- (int)countText;
- (int)countPunctuationWithCurrentTextCount:(int)currentTextCount;
- (int)countBytes;
- (void)encodeByteSegment:(int)bytes;
- (void)encodeTextSegment:(int)totalCount;
- (void)calculateErrorCorrection:(int *)codewords length:(int)length;
- (void)codewordToModules:(int)row col:(int)col codeword:(int)codeword matrix:(BOOL **)matrix;
- (void)encodeWithStringData:(NSString *)stringData;
- (void)SetDataColumns:(int)dataColumns;
- (void)SetDataRows:(int)dataRows;
- (int)dataRows;
- (int)dataColumns;
- (int)aspect1to2Column;
@end

